/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDays;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.common.DateHelper;

public class ProjectCalendarWeek
extends ProjectCalendarDays
implements Comparable<ProjectCalendarWeek> {
    private DateRange m_dateRange;

    public DateRange getDateRange() {
        return this.m_dateRange;
    }

    public void setDateRange(DateRange range) {
        this.m_dateRange = range;
    }

    public List<ProjectCalendarException> convertToRecurringExceptions(ProjectCalendar calendar) {
        Date fromDate;
        if (this.m_dateRange == null) {
            throw new UnsupportedOperationException();
        }
        ArrayList<ProjectCalendarException> result = new ArrayList<ProjectCalendarException>();
        Date earliestStartDate = calendar.getParentFile().getEarliestStartDate();
        if (DateHelper.compare(earliestStartDate, fromDate = this.m_dateRange.getStart()) > 0) {
            fromDate = earliestStartDate;
        }
        Date latestFinishDate = calendar.getParentFile().getLatestFinishDate();
        Date toDate = this.m_dateRange.getEnd();
        if (DateHelper.compare(toDate, latestFinishDate) > 0) {
            toDate = latestFinishDate;
        }
        for (Day day : Day.values()) {
            if (this.getCalendarDayType(day) == DayType.DEFAULT) continue;
            RecurringData recurrence = new RecurringData();
            recurrence.setRecurrenceType(RecurrenceType.WEEKLY);
            recurrence.setStartDate(fromDate);
            recurrence.setFinishDate(toDate);
            recurrence.setUseEndDate(true);
            recurrence.setWeeklyDay(day, true);
            ProjectCalendarException ex = new ProjectCalendarException(recurrence);
            ProjectCalendarHours hours = this.getCalendarHours(day);
            if (hours != null) {
                ex.addAll(hours);
            }
            result.add(ex);
        }
        return result;
    }

    @Override
    public int compareTo(ProjectCalendarWeek o) {
        long fromTime1 = this.m_dateRange.getStart().getTime();
        long fromTime2 = o.m_dateRange.getStart().getTime();
        return Long.compare(fromTime1, fromTime2);
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[ProjectCalendarWeek");
        pw.println("   name=" + this.getName());
        pw.println("   date_range=" + this.getDateRange());
        for (Day day : Day.values()) {
            pw.println("   [Day " + day);
            pw.println("      type=" + this.getCalendarDayType(day));
            pw.println("      hours=" + this.getCalendarHours(day));
            pw.println("   ]");
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

