/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.reader.AbstractProjectReader;

public abstract class AbstractProjectFileReader
extends AbstractProjectReader {
    @Override
    public ProjectFile read(String fileName) throws MPXJException {
        return this.read(new File(fileName));
    }

    @Override
    public List<ProjectFile> readAll(String fileName) throws MPXJException {
        return this.readAll(new File(fileName));
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        File tempFile = null;
        try {
            tempFile = InputStreamHelper.writeStreamToTempFile(inputStream, "tmp");
            ProjectFile projectFile = this.read(tempFile);
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to read file", ex);
        }
        finally {
            FileHelper.deleteQuietly(tempFile);
        }
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        File tempFile = null;
        try {
            tempFile = InputStreamHelper.writeStreamToTempFile(inputStream, "tmp");
            List<ProjectFile> list = this.readAll(tempFile);
            return list;
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to read file", ex);
        }
        finally {
            FileHelper.deleteQuietly(tempFile);
        }
    }
}

