/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/Keeper;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitor;", "", "Lorg/jetbrains/kotlin/ir/backend/js/utils/Keeper$KeepData;", "keep", "", "", "<init>", "(Ljava/util/Set;)V", "keptDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldKeep", "", "declaration", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "data", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "isInKeep", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "KeepData", "backend.js"})
@SourceDebugExtension(value={"SMAP\nKeeper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Keeper.kt\norg/jetbrains/kotlin/ir/backend/js/utils/Keeper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1761#2,3:69\n*S KotlinDebug\n*F\n+ 1 Keeper.kt\norg/jetbrains/kotlin/ir/backend/js/utils/Keeper\n*L\n18#1:69,3\n*E\n"})
public final class Keeper
extends IrVisitor<Unit, KeepData> {
    @NotNull
    private final Set<String> keep;
    @NotNull
    private final Set<IrDeclaration> keptDeclarations;

    public Keeper(@NotNull Set<String> keep) {
        Intrinsics.checkNotNullParameter(keep, "keep");
        this.keep = keep;
        this.keptDeclarations = new LinkedHashSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldKeep(@NotNull IrDeclaration declaration) {
        IrSymbolOwner irSymbolOwner;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (this.keptDeclarations.contains(declaration)) return true;
        if (!(declaration instanceof IrOverridableDeclaration)) return false;
        Iterable $this$any$iv = ((IrOverridableDeclaration)declaration).getOverriddenSymbols();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IrSymbol it = (IrSymbol)element$iv;
            boolean bl = false;
            irSymbolOwner = it.getOwner();
            Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        } while (!this.shouldKeep((IrDeclaration)irSymbolOwner));
        return true;
    }

    @Override
    public void visitElement(@NotNull IrElement element, @NotNull KeepData data) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(data, "data");
        element.acceptChildren(this, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @NotNull KeepData data) {
        boolean keptClass;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        boolean prevShouldBeKept = data.getClassShouldBeKept();
        boolean prevClassInKeep = data.getClassInKeep();
        data.setClassShouldBeKept(false);
        boolean bl = keptClass = data.getClassInKeep() || this.isInKeep(declaration);
        if (keptClass) {
            this.keptDeclarations.add(declaration);
        }
        data.setClassInKeep(keptClass);
        super.visitClass(declaration, data);
        if (data.getClassShouldBeKept()) {
            this.keptDeclarations.add(declaration);
        }
        data.setClassShouldBeKept(prevShouldBeKept);
        data.setClassInKeep(prevClassInKeep);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull KeepData data) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        super.visitDeclaration(declaration, data);
        if (this.keptDeclarations.contains(declaration)) {
            return;
        }
        if (declaration instanceof IrDeclarationWithName && this.isInKeep((IrDeclarationWithName)((Object)declaration)) || data.getClassInKeep()) {
            this.keptDeclarations.add(declaration);
            data.setClassShouldBeKept(true);
            return;
        }
    }

    private final boolean isInKeep(IrDeclarationWithName declaration) {
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable(declaration);
        return CollectionsKt.contains((Iterable)this.keep, fqName != null ? fqName.asString() : null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/Keeper$KeepData;", "", "classInKeep", "", "classShouldBeKept", "<init>", "(ZZ)V", "getClassInKeep", "()Z", "setClassInKeep", "(Z)V", "getClassShouldBeKept", "setClassShouldBeKept", "backend.js"})
    public static final class KeepData {
        private boolean classInKeep;
        private boolean classShouldBeKept;

        public KeepData(boolean classInKeep, boolean classShouldBeKept) {
            this.classInKeep = classInKeep;
            this.classShouldBeKept = classShouldBeKept;
        }

        public final boolean getClassInKeep() {
            return this.classInKeep;
        }

        public final void setClassInKeep(boolean bl) {
            this.classInKeep = bl;
        }

        public final boolean getClassShouldBeKept() {
            return this.classShouldBeKept;
        }

        public final void setClassShouldBeKept(boolean bl) {
            this.classShouldBeKept = bl;
        }
    }
}

