/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ErrorReporter {
    public static final String ERROR_FILE = "coverage-error.log";
    public static final String LOG_LEVEL_SYSTEM_PROPERTY = "idea.coverage.log.level";
    public static final String PATH_SYSTEM_PROPERTY = "idea.coverage.log.path";
    private static final SimpleDateFormat myDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int NONE = 4;
    private static File myFile;
    private static int myLogLevel;

    public static void suggestBasePath(String path) {
        String string;
        if (myFile != null) {
            return;
        }
        myFile = new File(string, ERROR_FILE);
    }

    public static void setPath(String path) {
        String string;
        myFile = path == null ? null : new File(string);
    }

    public static void setLogLevel(int level) {
        myLogLevel = level;
    }

    public static void error(String message) {
        String string;
        ErrorReporter.log(3, string, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void error(String message, Throwable t) {
        void var1_1;
        String string;
        ErrorReporter.log(3, string, (Throwable)var1_1);
    }

    public static void warn(String message) {
        String string;
        ErrorReporter.log(2, string, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void warn(String message, Throwable t) {
        void var1_1;
        String string;
        ErrorReporter.log(2, string, (Throwable)var1_1);
    }

    public static void info(String message) {
        String string;
        ErrorReporter.log(1, string, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void info(String message, Throwable t) {
        void var1_1;
        String string;
        ErrorReporter.log(1, string, (Throwable)var1_1);
    }

    public static void printInfo(String message) {
        String string;
        if (myLogLevel > 1) {
            return;
        }
        System.out.println(string);
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void log(int level, String message, Throwable t) {
        String prefix = ErrorReporter.logPrefix(level);
        PrintStream os = null;
        try {
            if (myFile != null) {
                os = new PrintStream(new FileOutputStream(myFile, true));
                ErrorReporter.printLogMessage(os, prefix, message, t);
            }
            if (level >= myLogLevel) {
                void var0_1;
                void var2_4;
                void var1_3;
                void var3_5;
                String consoleMessage = ErrorReporter.getConsoleMessage((String)var3_5, (String)var1_3, (Throwable)var2_4);
                System.err.println((String)var0_1);
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            CoverageIOUtil.close(os);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String logPrefix(int level) {
        void var1_1;
        int n;
        String levelString = "";
        switch (n) {
            case 0: {
                levelString = "DEBUG";
                break;
            }
            case 1: {
                levelString = " INFO";
                break;
            }
            case 2: {
                levelString = " WARN";
                break;
            }
            case 3: {
                levelString = "ERROR";
                break;
            }
            case 4: {
                throw new IllegalStateException("Should not get here!");
            }
        }
        return "[" + myDateFormat.format(new Date()) + "] (Coverage " + (String)var1_1 + "): ";
    }

    /*
     * WARNING - void declaration
     */
    private static String getConsoleMessage(String prefix, String message, Throwable t) {
        void var3_3;
        String string;
        StringBuilder buf = new StringBuilder();
        buf.append(string);
        if (message != null) {
            buf.append(message);
        }
        if (t != null) {
            void var2_2;
            void var1_1;
            if (var1_1 != null) {
                buf.append(": ");
            }
            buf.append(var2_2);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void printLogMessage(PrintStream out, String prefix, String message, Throwable t) {
        if (message != null) {
            void var2_2;
            out.println(prefix + (String)var2_2);
        } else {
            void var1_1;
            out.println((String)var1_1);
        }
        if (t != null) {
            PrintStream printStream;
            void var3_3;
            var3_3.printStackTrace(printStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void setUpFromSystemProperties() {
        void var0_1;
        void logLevel2;
        int logLevel2;
        String logLevelString;
        String path = System.getProperty(PATH_SYSTEM_PROPERTY);
        if (path != null) {
            ErrorReporter.setPath(path);
        }
        if ("none".equals(logLevelString = System.getProperty(LOG_LEVEL_SYSTEM_PROPERTY))) {
            logLevel2 = 4;
        } else if ("error".equals(logLevel2)) {
            logLevel2 = 3;
        } else if ("warn".equals(logLevel2)) {
            logLevel2 = 2;
        } else if ("info".equals(logLevel2)) {
            logLevel2 = 1;
        } else if ("debug".equals(logLevel2)) {
            logLevel2 = 0;
        } else {
            return;
        }
        ErrorReporter.setLogLevel((int)var0_1);
    }

    static {
        myLogLevel = 2;
        ErrorReporter.setUpFromSystemProperties();
    }
}

