/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;

public class ArtifactData {
    private final String artifactId;
    private final String groupId;
    private final String version;
    private final String classifier;
    private final String extension;
    private final Map<String, String> properties;

    ArtifactData(String artifactId, String groupId, String version, String classifier, String extension, Map<String, String> properties) {
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension;
        this.properties = properties;
    }

    ArtifactData(Artifact artifact) {
        this(artifact.getArtifactId(), artifact.getGroupId(), artifact.getVersion(), artifact.getClassifier(), artifact.getExtension(), artifact.getProperties());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactData data = (ArtifactData)o;
        if (!Objects.equals(this.artifactId, data.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.groupId, data.groupId)) {
            return false;
        }
        if (!Objects.equals(this.version, data.version)) {
            return false;
        }
        if (!Objects.equals(this.classifier, data.classifier)) {
            return false;
        }
        if (!Objects.equals(this.extension, data.extension)) {
            return false;
        }
        return Objects.equals(this.properties, data.properties);
    }

    public int hashCode() {
        int result = this.artifactId != null ? this.artifactId.hashCode() : 0;
        result = 31 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ArtifactData{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

