/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public final class GrImportUtil {
    public static boolean acceptName(GrReferenceElement ref2, String expected) {
        String actual = ref2.getReferenceName();
        if (expected.equals(actual)) {
            return true;
        }
        if (ref2.getQualifier() != null) {
            return false;
        }
        PsiFile file = ref2.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        MultiMap<String, String> data = GrImportUtil.getAliases((GroovyFile)file);
        Collection aliases = data.get((Object)expected);
        return aliases.contains(actual);
    }

    @NotNull
    private static MultiMap<String, String> getAliases(GroovyFile file) {
        MultiMap multiMap = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(GrImportUtil.collectAliases(file), (Object[])new Object[]{file}));
        if (multiMap == null) {
            GrImportUtil.$$$reportNull$$$0(0);
        }
        return multiMap;
    }

    @NotNull
    private static MultiMap<String, String> collectAliases(@NotNull GroovyFile file) {
        if (file == null) {
            GrImportUtil.$$$reportNull$$$0(1);
        }
        MultiMap aliases = MultiMap.createSet();
        for (GrImportStatement anImport : file.getImportStatements()) {
            String refName;
            GrCodeReferenceElement importReference;
            if (!anImport.isAliasedImport() || (importReference = anImport.getImportReference()) == null || (refName = importReference.getReferenceName()) == null) continue;
            aliases.putValue((Object)refName, (Object)anImport.getImportedName());
        }
        MultiMap multiMap = aliases;
        if (multiMap == null) {
            GrImportUtil.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/util/GrImportUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliases";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/util/GrImportUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAliases";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectAliases";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

