/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameJavaMethodProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameAliasedUsagesUtil;

public class RenameAliasImportedMethodProcessor
extends RenameJavaMethodProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof GroovyPsiElement && super.canProcessElement(element);
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(2);
        }
        Collection<PsiReference> collection = RenameAliasedUsagesUtil.filterAliasedRefs(super.findReferences(element, searchScope, searchInCommentsAndStrings), element);
        if (collection == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(4);
        }
        if (element == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(5);
        }
        return new RenameDialog(project, element, nameSuggestionContext, editor){

            protected boolean areButtonsValid() {
                return true;
            }
        };
    }

    public void renameElement(@NotNull PsiElement psiElement, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        PsiElement element;
        if (psiElement == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(7);
        }
        if (usages == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(8);
        }
        boolean isGetter = GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)psiElement);
        boolean isSetter = GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)psiElement);
        ArrayList<UsageInfo> methodAccess = new ArrayList<UsageInfo>(usages.length);
        ArrayList<UsageInfo> propertyAccess = new ArrayList<UsageInfo>(usages.length);
        for (UsageInfo usage : usages) {
            element = usage.getElement();
            if (element instanceof GrReferenceExpression && ((GrReferenceExpression)element).advancedResolve().isInvokedOnProperty()) {
                propertyAccess.add(usage);
                continue;
            }
            methodAccess.add(usage);
        }
        super.renameElement(psiElement, newName, methodAccess.toArray(UsageInfo.EMPTY_ARRAY), listener);
        String propertyName = isGetter ? GroovyPropertyUtils.getPropertyNameByGetterName(newName, true) : (isSetter ? GroovyPropertyUtils.getPropertyNameBySetterName(newName) : null);
        if (propertyName == null) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(psiElement.getProject());
            for (UsageInfo info : propertyAccess) {
                String qualifierPrefix;
                element = info.getElement();
                if (!(element instanceof GrReferenceExpression)) continue;
                PsiElement qualifier = ((GrReferenceExpression)element).getQualifier();
                String string = qualifierPrefix = qualifier == null ? "" : qualifier.getText() + ".";
                if (isGetter) {
                    GrExpression call = factory.createExpressionFromText(qualifierPrefix + newName + "()");
                    ((GrReferenceExpression)element).replaceWithExpression(call, true);
                    continue;
                }
                PsiElement parent = element.getParent();
                assert (parent instanceof GrAssignmentExpression);
                GrExpression rValue = ((GrAssignmentExpression)parent).getRValue();
                GrExpression call = factory.createExpressionFromText(qualifierPrefix + newName + "(" + (rValue == null ? "" : rValue.getText()) + ")");
                ((GrAssignmentExpression)parent).replaceWithExpression(call, true);
            }
        } else {
            for (UsageInfo usage : propertyAccess) {
                PsiReference ref2 = usage.getReference();
                if (ref2 == null) continue;
                ref2.handleElementRename(propertyName);
            }
        }
    }

    public void findCollisions(@NotNull PsiElement element, final @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        if (element == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(10);
        }
        if (allRenames == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(12);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            OverridingMethodsSearch.search((PsiMethod)method).forEach(overrider -> {
                PsiMethod original = overrider;
                if (overrider instanceof PsiMirrorElement) {
                    original = ((PsiMirrorElement)overrider).getPrototype();
                }
                if (original instanceof SyntheticElement) {
                    return true;
                }
                if (original instanceof GrField) {
                    result2.add((UsageInfo)new FieldNameCollisionInfo((GrField)original, method));
                }
                return true;
            });
        }
        ListIterator<UsageInfo> iterator2 = result2.listIterator();
        while (iterator2.hasNext()) {
            UsageInfo info = iterator2.next();
            final PsiElement ref2 = info.getElement();
            if (ref2 instanceof GrReferenceExpression || ref2 == null || RenameUtil.isValidName((Project)element.getProject(), (PsiElement)ref2, (String)newName)) continue;
            iterator2.add((UsageInfo)new UnresolvableCollisionUsageInfo(ref2, element){

                public String getDescription() {
                    return RefactoringBundle.message((String)"0.is.not.an.identifier", (Object[])new Object[]{newName, ref2.getText()});
                }
            });
        }
    }

    @Nullable
    protected PsiElement processRef(PsiReference ref2, String newName) {
        PsiElement element = ref2.getElement();
        if (RenameUtil.isValidName((Project)element.getProject(), (PsiElement)element, (String)newName) || element instanceof GrReferenceElement) {
            return super.processRef(ref2, newName);
        }
        if (!(element instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement nameElement = ((PsiReferenceExpression)element).getReferenceNameElement();
        TextRange range = nameElement.getTextRange();
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(nameElement.getContainingFile());
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newName);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/rename/RenameAliasImportedMethodProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/rename/RenameAliasImportedMethodProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCollisions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class FieldNameCollisionInfo
    extends UnresolvableCollisionUsageInfo {
        private final String myName;
        private final String myBaseName;

        FieldNameCollisionInfo(GrField field2, PsiMethod baseMethod) {
            super((PsiElement)field2, (PsiElement)field2);
            this.myName = field2.getName();
            this.myBaseName = baseMethod.getName();
        }

        public String getDescription() {
            return GroovyRefactoringBundle.message("cannot.rename.property.0", this.myName, this.myBaseName);
        }
    }
}

