/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.DynamicBundle;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.LabeledComponentNoThrow;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public class GroovyRunConfigurationEditor
extends SettingsEditor<GroovyScriptRunConfiguration>
implements PanelWithAnchor {
    private JPanel myMainPanel;
    private LabeledComponentNoThrow<TextFieldWithBrowseButton> myScriptPathComponent;
    private CommonJavaParametersPanel myCommonJavaParametersPanel;
    private LabeledComponentNoThrow<ModulesComboBox> myModulesComboBoxComponent;
    private JrePathEditor myJrePathEditor;
    private JCheckBox myDebugCB;
    private JCheckBox myAddClasspathCB;
    private JComponent myAnchor;

    public GroovyRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            GroovyRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        final TextFieldWithBrowseButton scriptPath = (TextFieldWithBrowseButton)this.myScriptPathComponent.getComponent();
        scriptPath.addBrowseFolderListener(project, FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)GroovyFileType.GROOVY_FILE_TYPE).withTitle(GroovyBundle.message("script.runner.chooser.title", new Object[0])).withDescription(GroovyBundle.message("script.runner.chooser.description", new Object[0])));
        ModulesComboBox modulesComboBox = (ModulesComboBox)this.myModulesComboBoxComponent.getComponent();
        modulesComboBox.addActionListener(e -> this.myCommonJavaParametersPanel.setModuleContext(modulesComboBox.getSelectedModule()));
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Function0 productionOnly = () -> {
            VirtualFile script = ScriptFileUtil.findScriptFileByPath((String)scriptPath.getText());
            return script != null && !fileIndex.isInTestSourceContent(script);
        };
        this.myJrePathEditor.setDefaultJreSelector((DefaultJreSelector)new DefaultJreSelector.SdkFromModuleDependencies<ModulesComboBox>(modulesComboBox, ModulesComboBox::getSelectedModule, productionOnly){

            public void addChangeListener(final @NotNull Runnable listener) {
                if (listener == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.addChangeListener(listener);
                ((JTextField)scriptPath.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        listener.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/runner/GroovyRunConfigurationEditor$1$1", "textChanged"));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/groovy/runner/GroovyRunConfigurationEditor$1", "addChangeListener"));
            }
        });
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myScriptPathComponent, this.myCommonJavaParametersPanel, this.myModulesComboBoxComponent, this.myJrePathEditor});
    }

    public void resetEditorFrom(@NotNull GroovyScriptRunConfiguration configuration) {
        if (configuration == null) {
            GroovyRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        ((TextFieldWithBrowseButton)this.myScriptPathComponent.getComponent()).setText(configuration.getScriptPath());
        this.myCommonJavaParametersPanel.reset((CommonJavaRunConfigurationParameters)configuration);
        ((ModulesComboBox)this.myModulesComboBoxComponent.getComponent()).setModules(configuration.getValidModules());
        ((ModulesComboBox)this.myModulesComboBoxComponent.getComponent()).setSelectedModule(configuration.getConfigurationModule().getModule());
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        this.myDebugCB.setSelected(configuration.isDebugEnabled());
        this.myAddClasspathCB.setSelected(configuration.isAddClasspathToTheRunner());
    }

    public void applyEditorTo(@NotNull GroovyScriptRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            GroovyRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        configuration.setScriptPath(((TextFieldWithBrowseButton)this.myScriptPathComponent.getComponent()).getText().trim());
        this.myCommonJavaParametersPanel.applyTo((CommonJavaRunConfigurationParameters)configuration);
        configuration.setModule(((ModulesComboBox)this.myModulesComboBoxComponent.getComponent()).getSelectedModule());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setDebugEnabled(this.myDebugCB.isSelected());
        configuration.setAddClasspathToTheRunner(this.myAddClasspathCB.isSelected());
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            GroovyRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myScriptPathComponent.setAnchor(anchor);
        this.myCommonJavaParametersPanel.setAnchor(anchor);
        this.myModulesComboBoxComponent.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JrePathEditor jrePathEditor;
        LabeledComponentNoThrow labeledComponentNoThrow;
        CommonJavaParametersPanel commonJavaParametersPanel;
        LabeledComponentNoThrow labeledComponentNoThrow2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScriptPathComponent = labeledComponentNoThrow2 = new LabeledComponentNoThrow();
        labeledComponentNoThrow2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponentNoThrow2.setLabelLocation("West");
        labeledComponentNoThrow2.setText(DynamicBundle.getBundle((String)"messages/GroovyBundle", GroovyRunConfigurationEditor.class).getString("run.configuration.script.path.label"));
        labeledComponentNoThrow2.setVerifyInputWhenFocusTarget(false);
        jPanel.add((Component)labeledComponentNoThrow2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCommonJavaParametersPanel = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 10), null));
        this.myModulesComboBoxComponent = labeledComponentNoThrow = new LabeledComponentNoThrow();
        labeledComponentNoThrow.setComponentClass("com.intellij.application.options.ModulesComboBox");
        labeledComponentNoThrow.setLabelLocation("West");
        labeledComponentNoThrow.setText(DynamicBundle.getBundle((String)"messages/GroovyBundle", GroovyRunConfigurationEditor.class).getString("run.configuration.module.chooser.label"));
        jPanel.add((Component)labeledComponentNoThrow, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel.add((Component)jrePathEditor, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 10), null));
        this.myDebugCB = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/GroovyBundle", GroovyRunConfigurationEditor.class).getString("debug.option"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAddClasspathCB = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/GroovyBundle", GroovyRunConfigurationEditor.class).getString("run.configuration.module.classpath.checkbox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/runner/GroovyRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/runner/GroovyRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

