/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class MavenProjectTimestamp {
    private final long myPomTimestamp;
    private final long myParentTimestamp;
    private final long myProfilesTimestamp;
    private final long myUserSettingsTimestamp;
    private final long myGlobalSettingsTimestamp;
    private final long myExplicitProfilesHashCode;
    private final long myJvmConfigTimestamp;
    private final long myMavenConfigTimestamp;
    static MavenProjectTimestamp NULL = new MavenProjectTimestamp(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);

    MavenProjectTimestamp(long pomTimestamp, long parentTimestamp, long profilesTimestamp, long userSettingsTimestamp, long globalSettingsTimestamp, long explicitProfilesHashCode, long jvmConfigTimestamp, long mavenConfigTimestamp) {
        this.myPomTimestamp = pomTimestamp;
        this.myParentTimestamp = parentTimestamp;
        this.myProfilesTimestamp = profilesTimestamp;
        this.myUserSettingsTimestamp = userSettingsTimestamp;
        this.myGlobalSettingsTimestamp = globalSettingsTimestamp;
        this.myExplicitProfilesHashCode = explicitProfilesHashCode;
        this.myJvmConfigTimestamp = jvmConfigTimestamp;
        this.myMavenConfigTimestamp = mavenConfigTimestamp;
    }

    public static MavenProjectTimestamp read(DataInputStream in) throws IOException {
        return new MavenProjectTimestamp(in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong());
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.myPomTimestamp);
        out.writeLong(this.myParentTimestamp);
        out.writeLong(this.myProfilesTimestamp);
        out.writeLong(this.myUserSettingsTimestamp);
        out.writeLong(this.myGlobalSettingsTimestamp);
        out.writeLong(this.myExplicitProfilesHashCode);
        out.writeLong(this.myJvmConfigTimestamp);
        out.writeLong(this.myMavenConfigTimestamp);
    }

    public String toString() {
        return "(" + this.myPomTimestamp + ":" + this.myParentTimestamp + ":" + this.myProfilesTimestamp + ":" + this.myUserSettingsTimestamp + ":" + this.myGlobalSettingsTimestamp + ":" + this.myExplicitProfilesHashCode + ":" + this.myJvmConfigTimestamp + ":" + this.myMavenConfigTimestamp + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenProjectTimestamp timestamp = (MavenProjectTimestamp)o;
        if (this.myPomTimestamp != timestamp.myPomTimestamp) {
            return false;
        }
        if (this.myParentTimestamp != timestamp.myParentTimestamp) {
            return false;
        }
        if (this.myProfilesTimestamp != timestamp.myProfilesTimestamp) {
            return false;
        }
        if (this.myUserSettingsTimestamp != timestamp.myUserSettingsTimestamp) {
            return false;
        }
        if (this.myGlobalSettingsTimestamp != timestamp.myGlobalSettingsTimestamp) {
            return false;
        }
        if (this.myExplicitProfilesHashCode != timestamp.myExplicitProfilesHashCode) {
            return false;
        }
        if (this.myJvmConfigTimestamp != timestamp.myJvmConfigTimestamp) {
            return false;
        }
        return this.myMavenConfigTimestamp == timestamp.myMavenConfigTimestamp;
    }

    public int hashCode() {
        int result2 = 0;
        result2 = 31 * result2 + Long.hashCode(this.myPomTimestamp);
        result2 = 31 * result2 + Long.hashCode(this.myParentTimestamp);
        result2 = 31 * result2 + Long.hashCode(this.myProfilesTimestamp);
        result2 = 31 * result2 + Long.hashCode(this.myUserSettingsTimestamp);
        result2 = 31 * result2 + Long.hashCode(this.myGlobalSettingsTimestamp);
        result2 = 31 * result2 + Long.hashCode(this.myExplicitProfilesHashCode);
        result2 = 31 * result2 + Long.hashCode(this.myJvmConfigTimestamp);
        result2 = 31 * result2 + Long.hashCode(this.myMavenConfigTimestamp);
        return result2;
    }
}

