/*
  SPDX-FileCopyrightText: 2025-2026 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once
#include "textautogeneratetext_export.h"
#include <QDialog>
#include <TextAutoGenerateText/TextAutoGenerateManager>
namespace TextAutoGenerateText
{
class TextAutoGenerateStackWidget;
/*!
 * \class TextAutoGenerateText::TextAutoGenerateDialog
 * \brief The TextAutoGenerateDialog class
 * \author Laurent Montel <montel@kde.org>
 * \inmodule TextAutoGenerateText
 * \inheaderfile TextAutoGenerateText/TextAutoGenerateDialog
 */
class TEXTAUTOGENERATETEXT_EXPORT TextAutoGenerateDialog : public QDialog
{
    Q_OBJECT
public:
    /*!
     * Constructs a new TextAutoGenerateDialog with manager.
     * \param manager The TextAutoGenerateManager instance
     * \param parent The parent widget
     */
    TextAutoGenerateDialog(TextAutoGenerateText::TextAutoGenerateManager *manager, QWidget *parent);
    /*!
     * Constructs a new TextAutoGenerateDialog.
     * \param parent The parent widget
     */
    explicit TextAutoGenerateDialog(QWidget *parent = nullptr);
    /*!
     * Destroys the TextAutoGenerateDialog.
     */
    ~TextAutoGenerateDialog() override;

    /*!
     * Sends a message to the assistant.
     * \param info The message information to send
     */
    void ask(const TextAutoGenerateText::TextAutoGenerateManager::AskMessageInfo &info);

private:
    TEXTAUTOGENERATETEXT_NO_EXPORT void readConfig();
    TEXTAUTOGENERATETEXT_NO_EXPORT void writeConfig();
    TextAutoGenerateText::TextAutoGenerateManager *const mTextAutoGenerateManager;
    TextAutoGenerateStackWidget *const mTextAutoGenerateWidget;
};
}
