/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.pool.KggHashGenerator;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.SQLUtil;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;

public class OracleShardingKeyImpl
implements OracleShardingKey {
    private static final String CLASS_NAME = OracleShardingKeyImpl.class.getName();
    private static final int DEFAULT_CHAR_CHARSET = 873;
    private static final int DEFAULT_NCHAR_CHARSET = 2000;
    private static final long ORA_HASH_MAX_VALUE = 0x100000000L;
    private final Datum[] subKeys;
    private final ShardingMetadata.SubKeyMetadata[] defaultSubKeyMetadata;
    private boolean isSuperShardingKey = false;
    private final long shardKeyOraHash;
    private final int hashCode;
    private static final NullShardingKeyType NULL_SHARD_KEY_LOW = new NullShardingKeyType(false);
    private static final NullShardingKeyType NULL_SHARD_KEY_HIGH = new NullShardingKeyType(true);

    protected OracleShardingKeyImpl(OracleShardingKeyBuilderImpl builder) {
        List<Object> keyObjects = builder.subKeyObjects();
        List<SQLType> keyType = builder.subKeyTypes();
        int size = Math.min(keyObjects.size(), keyType.size());
        Datum[] aDatum = new Datum[size];
        ShardingMetadata.SubKeyMetadata[] aSubKeyMetadata = new ShardingMetadata.SubKeyMetadata[size];
        int tempHashCode = 1;
        for (int i = 0; i < size; ++i) {
            Object subkey = keyObjects.get(i);
            SQLType subkeyType = keyType.get(i);
            int subKeyCharSet = -1;
            try {
                Datum subKeyData;
                if (!(subkey instanceof NullShardingKeyType)) {
                    subKeyCharSet = OracleShardingKeyImpl.getDefaultSubKeyCharSet(subkeyType.getVendorTypeNumber());
                    Class<? extends Datum> subKeyClass = this.getSubKeyDataClass(subkeyType.getVendorTypeNumber());
                    subKeyData = JavaToJavaConverter.convert(subkey, subKeyClass, null, null, CharacterSet.make(subKeyCharSet));
                } else {
                    subKeyData = (NullShardingKeyType)subkey;
                }
                aDatum[i] = subKeyData;
                tempHashCode = 31 * tempHashCode + (subKeyData == null ? 0 : ((Datum)subKeyData).bytesHashCode());
                aSubKeyMetadata[i] = new ShardingMetadata.SubKeyMetadata(i, subkeyType, subKeyCharSet);
                continue;
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Exception while processing sub key type " + e);
            }
        }
        this.subKeys = aDatum;
        this.defaultSubKeyMetadata = aSubKeyMetadata;
        this.hashCode = tempHashCode;
        this.shardKeyOraHash = builder.getOraHash();
    }

    public void markSuperShardingKey(boolean isSuperShardingKey) {
        this.isSuperShardingKey = isSuperShardingKey;
    }

    public boolean isSuperShardingKey() {
        return this.isSuperShardingKey;
    }

    @Override
    public int compareTo(OracleShardingKey o) {
        if (o == this) {
            return 0;
        }
        if (!(o instanceof OracleShardingKeyImpl)) {
            throw new IllegalArgumentException("Sharding Keys being compared are not of the same type");
        }
        OracleShardingKeyImpl key = (OracleShardingKeyImpl)o;
        if (this.shardKeyOraHash != -1L && key.shardKeyOraHash != -1L) {
            return this.shardKeyOraHash < key.shardKeyOraHash ? -1 : (this.shardKeyOraHash == key.shardKeyOraHash ? 0 : 1);
        }
        if (this.subKeys.length != key.subKeys.length) {
            throw new IllegalArgumentException("Sharding Keys being compared are not of the same type");
        }
        for (int i = 0; i < this.subKeys.length; ++i) {
            Datum o1 = this.subKeys[i];
            Datum o2 = key.subKeys[i];
            if (o1 instanceof NullShardingKeyType && o2 instanceof NullShardingKeyType) continue;
            if (o1 instanceof NullShardingKeyType) {
                if (((NullShardingKeyType)o1).isShardingKeyHigh()) {
                    return 1;
                }
                return -1;
            }
            if (o2 instanceof NullShardingKeyType) {
                if (((NullShardingKeyType)o2).isShardingKeyHigh()) {
                    return -1;
                }
                return 1;
            }
            int isEqual = Datum.compareBytes(o1.getBytes(), o2.getBytes());
            if (isEqual == 0) continue;
            return isEqual;
        }
        return 0;
    }

    public String toString() {
        try {
            return this.toString(null);
        }
        catch (SQLException e) {
            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "toString", "Exception in OracleShardingKeyImpl.toString()" + e, null, null);
            return null;
        }
    }

    public String toString(Connection conn) throws SQLException {
        if (this.subKeys == null || this.subKeys.length == 0) {
            return "";
        }
        StringBuffer keyStr = new StringBuffer();
        for (int i = 0; i < this.subKeys.length; ++i) {
            Datum key = this.subKeys[i];
            if (key instanceof TIMESTAMPLTZ) {
                if (conn != null) {
                    keyStr.append(((TIMESTAMPLTZ)key).stringValue(conn));
                } else {
                    keyStr.append(key.toString());
                }
            } else {
                keyStr.append(key.stringValue());
            }
            if (i + 1 >= this.subKeys.length) continue;
            keyStr.append(",");
        }
        return keyStr.toString();
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof OracleShardingKeyImpl)) {
            return false;
        }
        OracleShardingKeyImpl otherKey = (OracleShardingKeyImpl)otherObj;
        return Arrays.equals(this.subKeys, otherKey.subKeys);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String encodeKeyinB64Format() throws SQLException {
        return new Encoder().encodeKey(this);
    }

    public long shardKeyOraHash(ShardingMetadata metadata) {
        if (metadata == null) {
            return -1L;
        }
        if (this.shardKeyOraHash != -1L) {
            return this.shardKeyOraHash;
        }
        List<ShardingMetadata.SubKeyMetadata> dbSubKeyMetadata = this.isSuperShardingKey() ? metadata.getSuperShardingKeyColumns() : metadata.getShardingKeyColumns();
        List<Datum> listSubKeys = Arrays.asList(this.subKeys);
        long oraHash = listSubKeys.stream().filter(k -> k != null).map(k -> OracleShardingKeyImpl.encodeInDBCharset(k, ((ShardingMetadata.SubKeyMetadata)dbSubKeyMetadata.get(listSubKeys.indexOf(k))).getCharSet())).mapToLong(k -> Integer.toUnsignedLong(KggHashGenerator.hash(k))).sum();
        return oraHash % 0x100000000L;
    }

    public long getShardingKeyOraHash() {
        return this.shardKeyOraHash;
    }

    public byte[] sha256Hash(ShardingMetadata metadata) {
        MessageDigest md;
        if (metadata == null) {
            return null;
        }
        List<ShardingMetadata.SubKeyMetadata> dbSubKeyMetadata = this.isSuperShardingKey() ? metadata.getSuperShardingKeyColumns() : metadata.getShardingKeyColumns();
        byte[][] subKeysArr = new byte[this.subKeys.length][];
        int subKeysTotalLength = 0;
        for (int i = 0; i < this.subKeys.length; ++i) {
            if (this.subKeys[i] == null) continue;
            subKeysArr[i] = OracleShardingKeyImpl.encodeInDBCharset(this.subKeys[i], dbSubKeyMetadata.get(i).getCharSet());
            subKeysTotalLength += subKeysArr[i].length;
        }
        byte[] finalSKeyBytes = new byte[subKeysTotalLength];
        int destPos = 0;
        for (byte[] array : subKeysArr) {
            System.arraycopy(array, 0, finalSKeyBytes, destPos, array.length);
            destPos += array.length;
        }
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("No provider found to support SHA-256 digest", ex);
        }
        return md.digest(finalSKeyBytes);
    }

    public boolean isValid(ShardingMetadata metadata) {
        List<ShardingMetadata.SubKeyMetadata> dbSubKeyMetadata;
        if (metadata == null) {
            return true;
        }
        List<ShardingMetadata.SubKeyMetadata> list = dbSubKeyMetadata = this.isSuperShardingKey() ? metadata.getSuperShardingKeyColumns() : metadata.getShardingKeyColumns();
        if (dbSubKeyMetadata == null) {
            throw new IllegalStateException("Database metadata is not populated");
        }
        if (dbSubKeyMetadata.size() != this.subKeys.length) {
            return false;
        }
        ListIterator<ShardingMetadata.SubKeyMetadata> metaIt = dbSubKeyMetadata.listIterator();
        for (int i = 0; metaIt.hasNext() && i < this.subKeys.length; ++i) {
            ShardingMetadata.SubKeyMetadata keyMeta = metaIt.next();
            Datum subKey = this.subKeys[i];
            if (this.getSubKeyDataClass(keyMeta.getDataType().getVendorTypeNumber()).equals(subKey.getClass())) continue;
            return false;
        }
        return true;
    }

    private static int getDefaultSubKeyCharSet(int dataType) {
        if (dataType == 12 || dataType == 1) {
            return 873;
        }
        if (dataType == -9 || dataType == -15) {
            return 2000;
        }
        return -1;
    }

    private Class<? extends Datum> getSubKeyDataClass(int dataType) {
        Class subKeyClass = null;
        switch (dataType) {
            case 1: 
            case 12: {
                subKeyClass = CHAR.class;
                break;
            }
            case -15: 
            case -9: {
                subKeyClass = CHAR.class;
                break;
            }
            case 2: 
            case 6: {
                subKeyClass = NUMBER.class;
                break;
            }
            case 91: {
                subKeyClass = DATE.class;
                break;
            }
            case 93: {
                subKeyClass = TIMESTAMP.class;
                break;
            }
            case -102: {
                subKeyClass = TIMESTAMPLTZ.class;
                break;
            }
            case -2: {
                subKeyClass = RAW.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Type of sharding key ");
            }
        }
        return subKeyClass;
    }

    public static List<OracleShardingKeyImpl> decodeKeys(InputStream keysData, ShardingMetadata metadata, boolean isSuperKey, boolean isKeyHigh) throws SQLException {
        return new Decoder(metadata).decodeKey(keysData, isSuperKey, isKeyHigh);
    }

    private static byte[] encodeInDBCharset(Datum subKey, int dbCharSet) {
        Datum encodedSubKey;
        try {
            encodedSubKey = subKey instanceof CHAR ? new CHAR(subKey.toString(), CharacterSet.make(dbCharSet)) : subKey;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Invalid sharding key Character set specification in database", e);
        }
        return encodedSubKey.getBytes();
    }

    private static byte[] decodeInStandardCharset(byte[] dbEncodedKey, int dbCharSet, SQLType dbDataType) {
        byte[] defaultEncodedKey;
        try {
            switch ((OracleType)dbDataType) {
                case VARCHAR2: 
                case CHAR: 
                case NVARCHAR: 
                case NCHAR: {
                    CHAR charKey = new CHAR(dbEncodedKey, CharacterSet.make(dbCharSet));
                    defaultEncodedKey = new CHAR(charKey.getString(), CharacterSet.make(OracleShardingKeyImpl.getDefaultSubKeyCharSet(dbDataType.getVendorTypeNumber()))).getBytes();
                    break;
                }
                default: {
                    defaultEncodedKey = dbEncodedKey;
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Invalid sharding key Character set specification in database", e);
        }
        return defaultEncodedKey;
    }

    private static class NullShardingKeyType
    extends Datum {
        final boolean isHighKey;

        private NullShardingKeyType(boolean isHighKey) {
            this.isHighKey = isHighKey;
        }

        boolean isShardingKeyHigh() {
            return this.isHighKey;
        }

        @Override
        public String stringValue() {
            return this.isHighKey ? "MAX" : "MIN";
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof NullShardingKeyType;
        }

        @Override
        public int bytesHashCode() {
            return "NULL".hashCode();
        }

        public boolean isConvertibleTo(Class cls) {
            return false;
        }

        @Override
        public Object toJdbc() throws SQLException {
            return null;
        }

        @Override
        public Object makeJdbcArray(int arraySize) {
            return null;
        }

        public int hashCode() {
            return this.bytesHashCode();
        }
    }

    public static class Decoder {
        private final ShardingMetadata dbMetadata;

        public Decoder(ShardingMetadata metadata) {
            if (metadata == null) {
                throw new IllegalStateException("sharding key Metadata is null or not initialized");
            }
            this.dbMetadata = metadata;
        }

        List<OracleShardingKeyImpl> decodeBase64Key(String encodedShardKey, boolean isSuperShardingKey, boolean isHighKey) throws SQLException {
            if (encodedShardKey == null || encodedShardKey.length() == 0) {
                return null;
            }
            List<byte[]> subKeysByteArr = null;
            int keybodyIndex = encodedShardKey.indexOf(",");
            if (keybodyIndex < 0) {
                return null;
            }
            String keyBody = encodedShardKey.substring(keybodyIndex + 1);
            if (keyBody.isEmpty()) {
                return null;
            }
            List<String> subkeyStrings = Arrays.asList(keyBody.split(","));
            if (subkeyStrings.size() <= 0) {
                return null;
            }
            subKeysByteArr = subkeyStrings.stream().filter(k -> k != null).map(k -> Base64.getDecoder().decode((String)k)).collect(Collectors.toList());
            return this.buildShardKeys(subKeysByteArr, isSuperShardingKey, isHighKey);
        }

        List<OracleShardingKeyImpl> decodeKey(InputStream inStream, boolean isSuperShardingKey, boolean isHighKey) throws SQLException {
            ShardingKeyReader reader = new ShardingKeyReader(inStream);
            List<byte[]> subKeysByteArr = reader.hasKeys() ? reader.getKeys() : null;
            return this.buildShardKeys(subKeysByteArr, isSuperShardingKey, isHighKey);
        }

        public List<OracleShardingKeyImpl> buildShardKeys(List<byte[]> subKeysByteArr, boolean isSuperShardingKey, boolean isHighKey) throws SQLException {
            ListIterator<byte[]> keysItr;
            OracleShardingKeyImpl newKey;
            byte[] defaultEncodedKey;
            ArrayList<OracleShardingKeyImpl> decodedKeyList = new ArrayList<OracleShardingKeyImpl>();
            List<ShardingMetadata.SubKeyMetadata> dbSubKeyMetadataList = isSuperShardingKey ? this.dbMetadata.getSuperShardingKeyColumns() : this.dbMetadata.getShardingKeyColumns();
            ShardingMetadata.ShardingType shardType = isSuperShardingKey ? this.dbMetadata.getSuperShardingType() : this.dbMetadata.getShardingType();
            OracleShardingKeyBuilderImpl bldr = null;
            if (subKeysByteArr == null || subKeysByteArr.size() <= 0) {
                throw new IllegalStateException("Null sharding key values in database");
            }
            if (shardType == ShardingMetadata.ShardingType.HASH) {
                bldr = new OracleShardingKeyBuilderImpl();
                OracleShardingKeyImpl hashedKey = null;
                byte[] hashedKeyByteVal = subKeysByteArr.get(0);
                hashedKey = hashedKeyByteVal.length > 0 ? bldr.subkey(subKeysByteArr.get(0), OracleType.NUMBER).oraHash(NUMBER.toLong(subKeysByteArr.get(0))).build() : bldr.subkey(isHighKey ? NULL_SHARD_KEY_HIGH : NULL_SHARD_KEY_LOW, OracleType.ANYDATA).build();
                if (hashedKey != null) {
                    hashedKey.markSuperShardingKey(isSuperShardingKey);
                    decodedKeyList.add(hashedKey);
                }
                return decodedKeyList;
            }
            ListIterator<ShardingMetadata.SubKeyMetadata> metadataItr = dbSubKeyMetadataList.listIterator();
            bldr = new OracleShardingKeyBuilderImpl();
            if (shardType == ShardingMetadata.ShardingType.RANGE) {
                if (subKeysByteArr.size() != dbSubKeyMetadataList.size()) {
                    throw new IllegalStateException("Mismatch in Sharding database metadata and sharding key values");
                }
                List standardEncodedKeys = subKeysByteArr.stream().map(k -> {
                    int keyIdx = subKeysByteArr.indexOf(k);
                    ShardingMetadata.SubKeyMetadata meta = (ShardingMetadata.SubKeyMetadata)dbSubKeyMetadataList.get(keyIdx);
                    return OracleShardingKeyImpl.decodeInStandardCharset(k, meta.getCharSet(), meta.getDataType());
                }).collect(Collectors.toList());
                ListIterator keysItr2 = standardEncodedKeys.listIterator();
                while (metadataItr.hasNext() && keysItr2.hasNext()) {
                    defaultEncodedKey = (byte[])keysItr2.next();
                    ShardingMetadata.SubKeyMetadata dbSubKeyMetadata = metadataItr.next();
                    if (defaultEncodedKey.length == 0) {
                        bldr.subkey(isHighKey ? NULL_SHARD_KEY_HIGH : NULL_SHARD_KEY_LOW, OracleType.ANYDATA);
                        continue;
                    }
                    bldr.subkey(defaultEncodedKey, dbSubKeyMetadata.getDataType());
                }
                newKey = bldr.build();
                newKey.markSuperShardingKey(isSuperShardingKey);
                decodedKeyList.add(newKey);
            }
            if (shardType == ShardingMetadata.ShardingType.LIST) {
                keysItr = subKeysByteArr.listIterator();
                while (keysItr.hasNext()) {
                    while (metadataItr.hasNext()) {
                        ShardingMetadata.SubKeyMetadata dbSubKeyMetadata = metadataItr.next();
                        defaultEncodedKey = OracleShardingKeyImpl.decodeInStandardCharset(keysItr.next(), dbSubKeyMetadata.getCharSet(), dbSubKeyMetadata.getDataType());
                        bldr.subkey(defaultEncodedKey, dbSubKeyMetadata.getDataType());
                    }
                    OracleShardingKeyImpl newKey2 = bldr.build();
                    newKey2.markSuperShardingKey(isSuperShardingKey);
                    decodedKeyList.add(newKey2);
                    bldr = new OracleShardingKeyBuilderImpl();
                    metadataItr = dbSubKeyMetadataList.listIterator();
                }
            }
            if (shardType == ShardingMetadata.ShardingType.DIRECTORY) {
                keysItr = subKeysByteArr.listIterator();
                while (keysItr.hasNext()) {
                    bldr = new OracleShardingKeyBuilderImpl();
                    byte[] sha256Hash = keysItr.next();
                    newKey = sha256Hash.length > 0 ? bldr.subkey(sha256Hash, OracleType.RAW).build() : bldr.subkey(isHighKey ? NULL_SHARD_KEY_HIGH : NULL_SHARD_KEY_LOW, OracleType.ANYDATA).build();
                    newKey.markSuperShardingKey(isSuperShardingKey);
                    decodedKeyList.add(newKey);
                    bldr = new OracleShardingKeyBuilderImpl();
                }
            }
            return decodedKeyList;
        }

        private class ShardingKeyReader {
            private final InputStream stream;
            private boolean hasKeys = false;
            private static final int KDKLBLEN = 128;
            private static final int KDKLNULL = 255;

            public ShardingKeyReader(InputStream stream) {
                this.stream = stream;
                if (stream != null) {
                    this.hasKeys = true;
                }
            }

            public boolean hasKeys() {
                return this.hasKeys;
            }

            public List<byte[]> getKeys() {
                if (!this.hasKeys) {
                    return null;
                }
                ArrayList<byte[]> keys = new ArrayList<byte[]>();
                while (this.hasNext()) {
                    keys.add(this.next());
                }
                this.hasKeys = false;
                return keys;
            }

            private boolean hasNext() {
                try {
                    return this.stream.available() > 0;
                }
                catch (IOException e) {
                    this.hasKeys = false;
                    return false;
                }
            }

            private byte[] next() {
                try {
                    int len = this.stream.read();
                    if (len == 255) {
                        len = 0;
                    } else if (len >= 128) {
                        len = (len - 128 << 8) + this.stream.read();
                    }
                    byte[] value = new byte[len];
                    this.stream.read(value);
                    return value;
                }
                catch (IOException e) {
                    this.hasKeys = false;
                    return null;
                }
            }
        }
    }

    static class Encoder {
        private static final int TNS_HEADER_VERSION = 1;
        private final String headerVersionTypeStr;

        Encoder() {
            int tnsHeaderType = 0;
            this.headerVersionTypeStr = "1 " + tnsHeaderType;
        }

        String encodeKey(OracleShardingKey shardKeyToEncode) throws SQLException {
            String encodedStr = "";
            if (shardKeyToEncode == null) {
                return "";
            }
            OracleShardingKeyImpl shardKey = null;
            if (!(shardKeyToEncode instanceof OracleShardingKeyImpl)) {
                throw new IllegalArgumentException("Invalid type of sharding key for Encoding");
            }
            shardKey = (OracleShardingKeyImpl)shardKeyToEncode;
            if (shardKey.subKeys.length == 0) {
                return "";
            }
            String header = null;
            header = Arrays.asList(shardKey.defaultSubKeyMetadata).stream().filter(k -> k != null).map(k -> {
                try {
                    return "" + SQLUtil.getInternalType(k.getDataType().getVendorTypeNumber());
                }
                catch (SQLException e) {
                    throw new IllegalArgumentException("Invalid sharding key data type");
                }
            }).reduce(this.headerVersionTypeStr, (x, y) -> {
                x = (String)x + " " + y;
                return x;
            });
            encodedStr = Arrays.asList(shardKey.subKeys).stream().filter(k -> k != null).map(k -> Base64.getEncoder().encodeToString(k.getBytes())).reduce(header, (x, y) -> {
                x = (String)x + "," + y;
                return x;
            });
            return encodedStr;
        }
    }
}

