/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.resource.DriverResources;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.util.CommaListBuilder;
import oracle.net.ano.Ano;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnectDescription;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TcpsNTAdapter;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.AddrResolution;
import org.ietf.jgss.GSSCredential;

public abstract class NSProtocol
implements Communication,
SQLnetDef,
Diagnosable {
    private static final String CLASS_NAME = NSProtocol.class.getName();
    protected final AddrResolution addrRes;
    protected final SessionAtts sAtts;
    DMSFactory.DMSNoun dmsParent = null;

    protected NSProtocol(String connection, @Blind(value=PropertiesBlinder.class) Properties userProperties, SSLContext sslContext, OracleHostnameResolver hostnameResolver, boolean useDirectBuffers, Diagnosable diagnosable, TraceEventListener traceEventListener) throws NetException {
        if (connection == null) {
            throw new NetException(17908);
        }
        this.addrRes = new AddrResolution(connection, userProperties, sslContext, hostnameResolver, diagnosable, traceEventListener);
        this.sAtts = new SessionAtts(this, 0x200000, 0x200000, true, useDirectBuffers, diagnosable);
    }

    @Override
    public SessionAtts getSessionAttributes() {
        return this.sAtts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(GSSCredential gssCredential, DMSFactory.DMSNoun _dmsParent) throws IOException, NetException, InterruptedIOException {
        if (this.sAtts.connected) {
            throw new NetException(17901);
        }
        this.dmsParent = _dmsParent;
        Properties userProperties = this.addrRes.getUp();
        boolean disableOOB = this.getDisableOOBProperty(userProperties);
        boolean useZeroCopyIO = this.getZeroCopyIOProperty(userProperties);
        this.sAtts.traceId = (String)userProperties.get("T4CConnection.hashCode");
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "connect", "traceId={0}. ", null, null, this.sAtts.traceId);
        this.configureSessionAttsCompression(userProperties);
        try {
            this.establishConnection(null, true, this.dmsParent);
            if (NTAdapter.NetworkAdapterType.BEQ.equals((Object)this.sAtts.getNTAdapter().getNetworkAdapterType())) {
                String services = userProperties.getProperty("oracle.net.authentication_services");
                CommaListBuilder listBuilder = services != null && services.trim().length() > 0 ? CommaListBuilder.from(services) : new CommaListBuilder();
                listBuilder.add("BEQ");
                userProperties.setProperty("oracle.net.authentication_services", listBuilder.format());
            }
            this.configureSessionAttsAno(userProperties);
            this.negotiateConnection(new NVFactory(), new NVNavigator(), disableOOB, useZeroCopyIO, this.dmsParent);
            if (this.isTLSEnabled()) {
                ((TcpsNTAdapter)this.sAtts.getNTAdapter()).verifyDN();
            }
            this.configureSessionAttsAfterNegotiation(userProperties);
            this.initializeAno(gssCredential);
        }
        finally {
            this.cancelOutboundTimeoutInterrupt();
        }
        this.addrRes.connection_redirected = false;
        this.sAtts.initializeNetProperties(userProperties);
    }

    @Override
    public CompletionStage<Void> connectAsync(GSSCredential gssCredential, DMSFactory.DMSNoun _dmsParent, AsyncOutboundTimeoutHandler loginTimeoutHandler, Executor asyncExecutor) {
        if (this.sAtts.connected) {
            return CompletionStageUtil.failedStage(new NetException(17901));
        }
        this.dmsParent = _dmsParent;
        Properties userProperties = this.addrRes.getUp();
        boolean disableOOB = this.getDisableOOBProperty(userProperties);
        boolean useZeroCopyIO = this.getZeroCopyIOProperty(userProperties);
        this.sAtts.traceId = (String)userProperties.get("T4CConnection.hashCode");
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "connectAsync", "traceId={0}. ", null, null, this.sAtts.traceId);
        String connection = this.addrRes.connection_revised ? this.addrRes.getTNSAddressInUpperCase() : this.addrRes.getTNSAddress();
        this.configureSessionAttsCompression(userProperties);
        AsyncOutboundTimeoutHandler outboundTimeoutHandler = AsyncOutboundTimeoutHandler.newInstance(loginTimeoutHandler);
        Properties finalUserProperties = userProperties;
        return this.establishConnectionAsync(connection, true, this.dmsParent, outboundTimeoutHandler, asyncExecutor).thenCompose(CompletionStageUtil.normalCompletionHandler(initializedSessionAtts -> {
            this.configureSessionAttsAno(finalUserProperties);
            return this.negotiateConnectionAsync(new NVFactory(), new NVNavigator(), disableOOB, useZeroCopyIO, this.dmsParent, outboundTimeoutHandler, asyncExecutor);
        })).thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
            if (this.isTLSEnabled()) {
                ((TcpsNTAdapter)this.sAtts.getNTAdapter()).verifyDN();
            }
            this.configureSessionAttsAfterNegotiation(finalUserProperties);
            outboundTimeoutHandler.setInterruptThread(Thread.currentThread());
            try {
                this.initializeAno(gssCredential);
            }
            finally {
                outboundTimeoutHandler.setInterruptThread(null);
            }
            return nil;
        })).whenComplete((nil, err) -> {
            outboundTimeoutHandler.cancelTimeout();
            if (err == null) {
                this.addrRes.connection_redirected = false;
                try {
                    this.sAtts.initializeNetProperties(finalUserProperties);
                }
                catch (IOException initializationFailure) {
                    throw new CompletionException(initializationFailure);
                }
            }
        });
    }

    private final boolean getDisableOOBProperty(Properties userProperties) {
        String disableOOBValue = (String)userProperties.get("DISABLE_OOB");
        return "true".equals(disableOOBValue);
    }

    private final boolean getZeroCopyIOProperty(Properties userProperties) {
        if (this.sAtts.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            return false;
        }
        String zeroCopyIOValue = (String)userProperties.get("USE_ZERO_COPY_IO");
        return zeroCopyIOValue == null || !"false".equals(zeroCopyIOValue);
    }

    private final void configureSessionAttsCompression(Properties userProperties) {
        this.sAtts.networkCompression = userProperties.getProperty("oracle.net.networkCompression", "off").toLowerCase();
        this.sAtts.networkCompressionThreshold = Integer.parseInt(userProperties.getProperty("oracle.net.networkCompressionThreshold", "1024"));
        String levels_string = userProperties.getProperty("oracle.net.networkCompressionLevels", "(high)");
        this.sAtts.networkCompressionLevelsArray = new ArrayList();
        if (levels_string.equals("(high)")) {
            this.sAtts.networkCompressionLevelsArray.add("high");
        } else {
            String[] levels_tokens;
            levels_string = levels_string.trim();
            levels_string = levels_string.substring(1, levels_string.length() - 1);
            for (String level : levels_tokens = levels_string.split("\\s+|,")) {
                if (level.equals("")) continue;
                this.sAtts.networkCompressionLevelsArray.add(level.toLowerCase());
            }
        }
    }

    private final void configureSessionAttsAno(Properties userProperties) throws NetException {
        this.sAtts.profile = new ClientProfile(userProperties);
        this.sAtts.ano = new Ano();
        this.sAtts.ano.init(this.sAtts, this.sAtts.isJavaNetNIO);
        this.sAtts.anoEnabled = true;
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "configureSessionAttsAno", "traceId={0}, anoEnabled={1}. ", null, null, this.sAtts.traceId, this.sAtts.anoEnabled);
    }

    private final void configureSessionAttsAfterNegotiation(Properties userProperties) throws IOException {
        this.sAtts.connected = true;
        this.sAtts.nt.setReadTimeoutIfRequired(userProperties);
    }

    private final void initializeAno(GSSCredential gssCredential) throws IOException, NetException {
        if (this.sAtts.noAnoServices) {
            if (this.sAtts.profile.getEncryptionLevelNum() == 3 || this.sAtts.profile.getDataIntegrityLevelNum() == 3) {
                throw new NetException(18920, "(encryption / checksumming required by client but disabled by server)");
            }
            this.sAtts.setNetProperty("oracle.jdbc.isANONegotiationDone", "false");
        } else {
            this.begin(Metrics.ConnectionEvent.ASO_NEGOTIATION);
            this.sAtts.ano.negotiation(this.addrRes.connection_redirected, this.sAtts.isJavaNetNIO, gssCredential);
            this.end(Metrics.ConnectionEvent.ASO_NEGOTIATION);
            this.sAtts.setNetProperty("oracle.jdbc.isANONegotiationDone", "true");
        }
    }

    private final void cancelOutboundTimeoutInterrupt() throws NetException {
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "cancelOutboundTimeoutInterrupt", "Cancelling  the outbound interrupt timer {0}. ", (String)null, null, (Object)interruptTask);
        if (interruptTask != null && interruptTask.isInterrupted()) {
            Thread.interrupted();
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "cancelOutboundTimeoutInterrupt", "Outbound timeout happened, throwing socket timeout exception. ", null, null, new Object[0]);
            throw new NetException(18953);
        }
    }

    abstract void negotiateConnection(NVFactory var1, NVNavigator var2, boolean var3, boolean var4, DMSFactory.DMSNoun var5) throws IOException, NetException;

    abstract CompletionStage<Void> negotiateConnectionAsync(NVFactory var1, NVNavigator var2, boolean var3, boolean var4, DMSFactory.DMSNoun var5, AsyncOutboundTimeoutHandler var6, Executor var7);

    @Override
    public void sendBreak() throws IOException, NetException {
        if (this.sAtts.isExpediatedAttentionEnabled()) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "sendBreak", "Sending urgent marker.  sessionTraceId={0}. ", null, null, this.sAtts.traceId);
            this.sAtts.nt.sendUrgentByte(33);
            if (this.sAtts.isAttentionProcessingEnabled()) {
                this.sendMarker(2, (byte)1);
            }
        } else {
            this.sendMarker(1, (byte)1);
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if (this.sAtts.isExpediatedAttentionEnabled()) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "sendInterrupt", "Sending urgent marker.  SessionTraceId={0}. ", null, null, this.sAtts.traceId);
            this.sAtts.nt.sendUrgentByte(33);
            if (this.sAtts.isAttentionProcessingEnabled()) {
                this.sendMarker(2, (byte)3);
            }
        } else {
            this.sendMarker(1, (byte)3);
        }
    }

    protected abstract void sendMarker(int var1, byte var2) throws IOException, NetException;

    @Override
    public void setOption(int option, Object value) throws NetException, IOException {
        if (option > 100 && option < 110) {
            NTAdapter nt = this.sAtts.getNTAdapter();
            nt.setOption(option, value);
        }
    }

    @Override
    public Object getOption(int option) throws NetException, IOException {
        if (option > 100 && option < 110) {
            NTAdapter nt = this.sAtts.getNTAdapter();
            return nt.getOption(option);
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        NTAdapter nt = this.sAtts.getNTAdapter();
        if (nt != null) {
            nt.abort();
        }
    }

    @Override
    public String getEncryptionName() {
        String ret = null;
        NTAdapter ntadapter = this.sAtts.getNTAdapter();
        try {
            ret = (String)ntadapter.getOption(105);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null && this.sAtts.ano != null) {
            ret = this.sAtts.ano.getEncryptionName();
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    @Override
    public String getAccessBanner() {
        return this.sAtts.getConnectData();
    }

    @Override
    public String getDataIntegrityName() {
        String ret = "";
        if (this.sAtts.ano != null) {
            ret = this.sAtts.ano.getDataIntegrityName();
        }
        return ret;
    }

    @Override
    public String getAuthenticationAdaptorName() {
        String ret = "";
        if (this.sAtts.ano != null) {
            ret = this.sAtts.ano.getAuthenticationAdaptorName();
        }
        return ret;
    }

    @Override
    public void cancelTimeout() {
    }

    public void reconnectIfRequired(boolean probe) throws IOException, InterruptedIOException {
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.sAtts.timestampLastIO;
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "reconnectIfRequired", "Elapsed Time={0}, Timeout={1}, Reconnect={2}, SessionTraceId={3}. ", null, null, elapsedTime, this.sAtts.timeout, elapsedTime > (long)this.sAtts.timeout, this.sAtts.traceId);
        if (elapsedTime > (long)this.sAtts.timeout) {
            this.reconnect(probe);
        }
    }

    @Override
    public void setAuthSessionKey(byte[] sessionKey) throws NetException {
        if (sessionKey != null && (this.sAtts.isEncryptionActive || this.sAtts.isChecksumActive)) {
            this.sAtts.ano.setAuthSessionKey(sessionKey);
        }
    }

    @Override
    public void doKeyFoldinForExternalAuth() {
        if ((this.sAtts.isEncryptionActive || this.sAtts.isChecksumActive) && !this.sAtts.profile.useWeakCrypto()) {
            this.sAtts.ano.setAuthSessionKey(this.sAtts.ano.getExternalAuthSessionKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(boolean probe) throws IOException, InterruptedIOException {
        try {
            String reconnectAddress = new String(this.sAtts.reconnectAddress);
            this.sAtts.attemptingReconnect = true;
            ConnOption origConnOption = this.sAtts.cOption.getOriginalConnOption();
            this.addrRes.connection_redirected = true;
            this.sAtts.cOption.nt.disconnect();
            this.establishConnection(reconnectAddress, false, this.dmsParent);
            this.sAtts.cOption.setOriginalConnOption(origConnOption);
            if (probe) {
                this.sendProbePacket();
            }
        }
        finally {
            this.sAtts.attemptingReconnect = false;
        }
    }

    protected void validateRedirectResponse(String rdAddress) throws IOException {
        if (!"TCPS".equalsIgnoreCase(this.sAtts.cOption.getOriginalConnOption().protocol)) {
            return;
        }
        try {
            NVNavigator nav = new NVNavigator();
            NVPair rootNVPair = new NVFactory().createNVPair(rdAddress);
            NVPair protocolNV = nav.findNVPairRecurse(rootNVPair, "PROTOCOL");
            if (protocolNV != null && !"TCPS".equalsIgnoreCase(protocolNV.getAtom())) {
                throw new NetException(17962);
            }
            NVPair securityNV = nav.findNVPairRecurse(rootNVPair, "SECURITY");
            if (securityNV != null) {
                throw new NetException(17963);
            }
        }
        catch (NLException e) {
            throw new NetException(17964);
        }
    }

    SessionAtts establishConnection(String connection, DMSFactory.DMSNoun dmsParent) throws NetException, IOException, InterruptedIOException {
        return this.establishConnection(connection, false, dmsParent);
    }

    SessionAtts establishConnection(String connection, boolean startNewOCTOInterruptTask, DMSFactory.DMSNoun dmsParent) throws NetException, IOException, InterruptedIOException {
        this.sAtts.cOption = this.addrRes.resolveAndExecute(connection, startNewOCTOInterruptTask, dmsParent);
        if (this.sAtts.cOption == null) {
            return null;
        }
        this.sAtts.nt = this.sAtts.cOption.nt;
        this.sAtts.networkType = this.sAtts.nt.getNetworkAdapterType();
        this.sAtts.setTDU(this.sAtts.cOption.tdu);
        this.sAtts.setSDU(this.sAtts.cOption.sdu);
        this.sAtts.setNetConnectionIdPrefix(this.addrRes.getConnStrategy().getConnectionIdPrefix());
        this.initializeSessionAttributes();
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "establishConnection", "{0}", null, null, this.sAtts);
        return this.sAtts;
    }

    final CompletionStage<SessionAtts> establishConnectionAsync(String connection, boolean startNewOCTOInterruptTask, DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        return this.addrRes.resolveAndExecuteAsync(connection, startNewOCTOInterruptTask, dmsParent, outboundTimeoutHandler, asyncExecutor).thenApply(executedConnOption -> {
            this.sAtts.cOption = executedConnOption;
            if (this.sAtts.cOption == null) {
                return null;
            }
            this.sAtts.nt = this.sAtts.cOption.nt;
            this.sAtts.networkType = this.sAtts.nt.getNetworkAdapterType();
            this.sAtts.setTDU(this.sAtts.cOption.tdu);
            this.sAtts.setSDU(this.sAtts.cOption.sdu);
            try {
                this.initializeSessionAttributes();
            }
            catch (IOException initializationFailure) {
                throw new CompletionException(initializationFailure);
            }
            return this.sAtts;
        });
    }

    abstract void initializeSessionAttributes() throws NetException, IOException;

    abstract void sendProbePacket() throws IOException;

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.addrRes.isConnectionSocketKeepAlive();
    }

    @Override
    public int getSocketReadTimeout() throws NetException, IOException {
        String millis = (String)this.getOption(101);
        int milliseconds = millis == null || "".equals(millis) ? 0 : Integer.parseInt(millis);
        return milliseconds;
    }

    @Override
    public void setSocketReadTimeout(int milliseconds) throws NetException, IOException {
        String millis = Integer.toString(milliseconds);
        this.setOption(101, millis);
    }

    @Override
    public String getConnectionString() {
        return this.addrRes.getTNSAddress();
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getSocketOptions() {
        return this.addrRes.getSocketOptions();
    }

    @Override
    public int getNegotiatedSDU() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(17900);
        }
        return this.sAtts.negotiatedSDU;
    }

    @Override
    public NetStat getNetworkStat() {
        return this.sAtts.nt.getNetStat();
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return this.sAtts.networkCompressionEnabled;
    }

    @Override
    public int getOutboundConnectTimeout() {
        int retVal = 0;
        if (this.addrRes != null) {
            retVal = this.addrRes.getConnStrategy().getOutboundConnectTimeout();
        }
        return retVal;
    }

    @Override
    public boolean isUsingCustomHostnameResolver() {
        return this.addrRes.isUsingCustomHostnameResolver();
    }

    void tryUrgentByte() {
        try {
            this.sAtts.nt.sendUrgentByte(33);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.getSessionAttributes().getDiagnosable();
    }

    @Override
    public final List<ConnectDescription> getConnectDescriptions() {
        return this.addrRes.getResolvedDescriptions();
    }

    @Override
    public final ConnectDescription getConnectedDescription() {
        return this.addrRes.getConnectedDescription();
    }

    @Override
    public final void setDriverResources(DriverResources driverResources) {
        this.addrRes.setDriverResources(driverResources);
    }
}

