"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.catIndicesRoute = catIndicesRoute;
var _configSchema = require("@osd/config-schema");
var _util = require("../utils/util");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function catIndicesRoute(router, dataSourceEnabled) {
  router.get({
    path: '/api/data_importer/_cat_indices',
    validate: {
      query: _configSchema.schema.object({
        dataSource: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    const client = await (0, _util.decideClient)(dataSourceEnabled, context, request.query.dataSource);
    if (!!!client) {
      return response.notFound({
        body: 'Data source is not enabled or does not exist'
      });
    }
    try {
      const indices = await client.cat.indices({
        format: 'json'
      });
      return response.ok({
        body: {
          indices: indices.body.filter(index => {
            var _index$index;
            return !((_index$index = index.index) !== null && _index$index !== void 0 && _index$index.startsWith('.'));
          }).map(index => index.index || 'unknown')
        }
      });
    } catch (e) {
      return response.internalError({
        body: `Error when listing indices: ${e}`
      });
    }
  });
}