/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.opensearch.knn.quantization.models.quantizationParams.QuantizationParams;
import org.opensearch.knn.quantization.quantizer.Quantizer;

final class QuantizerRegistry {
    private static final Map<String, Quantizer<?, ?>> registry = new ConcurrentHashMap();

    static void register(String paramIdentifier, Quantizer<?, ?> quantizer) {
        if (registry.putIfAbsent(paramIdentifier, quantizer) != null) {
            throw new IllegalArgumentException("Quantizer already registered for identifier: " + paramIdentifier);
        }
    }

    static <P extends QuantizationParams, T, R> Quantizer<T, R> getQuantizer(P params) {
        String identifier = params.getTypeIdentifier();
        Quantizer<?, ?> quantizer = registry.get(identifier);
        if (quantizer == null) {
            throw new IllegalArgumentException("No quantizer registered for type identifier: " + identifier);
        }
        return quantizer;
    }

    @Generated
    private QuantizerRegistry() {
    }
}

