/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

final class Jep380SocketChannelImplAdapter
extends SocketImpl {
    private final SocketChannel channel;
    volatile int soTimeoutMs = 0;

    public Jep380SocketChannelImplAdapter(SocketChannel channel) throws IOException {
        this.channel = channel;
    }

    @Override
    protected void close() throws IOException {
        this.channel.close();
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return new InputStreamAdapter();
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return new OutputStreamAdapter();
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        try {
            switch (optID) {
                case 4102: {
                    return this.soTimeoutMs;
                }
                case 4098: {
                    return this.channel.getOption(StandardSocketOptions.SO_RCVBUF);
                }
                case 4097: {
                    return this.channel.getOption(StandardSocketOptions.SO_SNDBUF);
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        throw new UnsupportedOperationException("getOption: " + optID);
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        try {
            switch (optID) {
                case 4102: {
                    this.soTimeoutMs = (Integer)value;
                    return;
                }
                case 4098: {
                    this.channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Integer)value);
                    return;
                }
                case 4097: {
                    this.channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Integer)value);
                    return;
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void accept(SocketImpl s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void bind(InetAddress host, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void connect(String host, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void create(boolean stream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void listen(int backlog) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        throw new UnsupportedOperationException();
    }

    private class OutputStreamAdapter
    extends OutputStream {
        private final Selector sel = Selector.open();
        private final SelectionKey key;

        private OutputStreamAdapter() throws IOException {
            this.key = Jep380SocketChannelImplAdapter.this.channel.register(this.sel, 4);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            while (buf.hasRemaining()) {
                int n = Jep380SocketChannelImplAdapter.this.channel.write(buf);
                if (n != 0) continue;
                if (this.sel.select(60000L) == 0) {
                    throw new SocketTimeoutException("write timed out");
                }
                this.sel.selectedKeys().clear();
            }
        }

        @Override
        public void close() throws IOException {
            this.key.cancel();
            this.sel.close();
            Jep380SocketChannelImplAdapter.this.channel.close();
        }
    }

    private class InputStreamAdapter
    extends InputStream {
        private final Selector sel = Selector.open();
        private final SelectionKey key;

        private InputStreamAdapter() throws IOException {
            this.key = Jep380SocketChannelImplAdapter.this.channel.register(this.sel, 1);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b, 0, 1);
            return n == -1 ? -1 : b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            if (this.sel.select(Jep380SocketChannelImplAdapter.this.soTimeoutMs) == 0) {
                throw new SocketTimeoutException();
            }
            int read = Jep380SocketChannelImplAdapter.this.channel.read(buf);
            this.sel.selectedKeys().clear();
            return read;
        }

        @Override
        public void close() throws IOException {
            this.key.cancel();
            this.sel.close();
            Jep380SocketChannelImplAdapter.this.channel.close();
        }
    }
}

