/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.backend.libffi.LibFFIContext;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.NFIUnsatisfiedLinkError;
import com.oracle.truffle.nfi.backend.libffi.NativeAllocation;
import java.io.PrintStream;

@ExportLibrary(value=InteropLibrary.class)
final class LibFFILibrary
implements TruffleObject {
    private static final boolean LOG_UNLOAD = Boolean.getBoolean("trufflenfi.log.Unload");
    private static final EmptyKeysArray KEYS = new EmptyKeysArray();
    protected final long handle;

    static LibFFILibrary createDefault() {
        return new LibFFILibrary(0L);
    }

    static LibFFILibrary create(long handle, String name) {
        assert (handle != 0L);
        LibFFILibrary ret = new LibFFILibrary(handle);
        NativeAllocation.getGlobalQueue().registerNativeAllocation(ret, new Destructor(handle, name));
        return ret;
    }

    private LibFFILibrary(long handle) {
        this.handle = handle;
    }

    @ExportMessage
    static boolean isPointer(LibFFILibrary self) {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.handle;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return KEYS;
    }

    @ExportMessage
    boolean isMemberReadable(String member) {
        return true;
    }

    @ExportMessage
    Object readMember(String symbol, @Cached InlinedBranchProfile exception, @Bind Node node) throws UnknownIdentifierException {
        try {
            return LibFFIContext.get(node).lookupSymbol(this, symbol);
        }
        catch (NFIUnsatisfiedLinkError ex) {
            exception.enter(node);
            throw UnknownIdentifierException.create((String)symbol);
        }
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return LibFFILanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return "LibFFILibrary(" + this.handle + ")";
    }

    private static final class Destructor
    extends NativeAllocation.Destructor {
        private final long handle;
        private final String name;

        private Destructor(long handle, String name) {
            this.handle = handle;
            this.name = name;
        }

        @Override
        protected void destroy() {
            if (LOG_UNLOAD) {
                PrintStream stream = System.err;
                stream.println("[nfi] Unloading library " + this.name);
            }
            LibFFIContext.freeLibrary(this.handle);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class EmptyKeysArray
    implements TruffleObject {
        EmptyKeysArray() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return 0L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return false;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            throw InvalidArrayIndexException.create((long)index);
        }
    }
}

