/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.asynccontext;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.asynccontext.AsyncContextVariablePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContextVariable;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContextVariableObject;
import com.oracle.truffle.js.runtime.objects.AsyncContext;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class AsyncContextVariablePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<AsyncContextVariablePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new AsyncContextVariablePrototypeBuiltins();

    protected AsyncContextVariablePrototypeBuiltins() {
        super(JSAsyncContextVariable.PROTOTYPE_NAME, AsyncContextVariablePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, AsyncContextVariablePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return AsyncContextVariablePrototypeBuiltinsFactory.AsyncContextRunNodeGen.create(context, builtin, AsyncContextVariablePrototypeBuiltins.args().withThis().fixedArgs(2).varArgs().createArgumentNodes(context));
            }
            case 1: {
                return AsyncContextVariablePrototypeBuiltinsFactory.AsyncContextGetNodeGen.create(context, builtin, AsyncContextVariablePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 2: {
                return AsyncContextVariablePrototypeBuiltinsFactory.AsyncContextNameNodeGen.create(context, builtin, AsyncContextVariablePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AsyncContextVariablePrototype implements BuiltinEnum<AsyncContextVariablePrototype>
    {
        run(2),
        get(0),
        name(0){

            @Override
            public boolean isGetter() {
                return true;
            }
        };

        private final int length;

        private AsyncContextVariablePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSAsyncContextVariable.class})
    public static abstract class AsyncContextRunNode
    extends JSBuiltinNode {
        public AsyncContextRunNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object run(JSAsyncContextVariableObject thisObj, Object value, Object func, Object[] args, @Cached(value="createCall()") JSFunctionCallNode callNode) {
            JSAgent agent = this.getRealm().getAgent();
            AsyncContext previousContextMapping = agent.getAsyncContextMapping();
            AsyncContext asyncContextMapping = previousContextMapping.withMapping(thisObj.getAsyncContextKey(), value);
            agent.asyncContextSwap(asyncContextMapping);
            try {
                Object object = callNode.executeCall(JSArguments.create((Object)Undefined.instance, func, args));
                return object;
            }
            finally {
                agent.asyncContextSwap(previousContextMapping);
            }
        }

        @Specialization(guards={"!isJSAsyncContextVariable(thisObj)"})
        protected Object invalidReceiver(Object thisObj, Object value, Object func, Object[] args) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    @ImportStatic(value={JSAsyncContextVariable.class})
    public static abstract class AsyncContextGetNode
    extends JSBuiltinNode {
        public AsyncContextGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object get(JSAsyncContextVariableObject thisObj) {
            return this.getRealm().getAgent().getAsyncContextMapping().getOrDefault(thisObj.getAsyncContextKey(), thisObj.getAsyncContextDefaultValue());
        }

        @Specialization(guards={"!isJSAsyncContextVariable(thisObj)"})
        protected Object invalidReceiver(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    @ImportStatic(value={JSAsyncContextVariable.class})
    public static abstract class AsyncContextNameNode
    extends JSBuiltinNode {
        public AsyncContextNameNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object name(JSAsyncContextVariableObject thisObj) {
            return thisObj.getAsyncContextKey().getDescription();
        }

        @Specialization(guards={"!isJSAsyncContextVariable(thisObj)"})
        protected Object invalidReceiver(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }
}

