/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.tregex.automaton.TransitionOp;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractTransitionNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;

public final class DFABQTrackingTransitionOpsNode
extends DFAAbstractTransitionNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final long[] operations;

    public DFABQTrackingTransitionOpsNode(short id, short successor, long[] operations) {
        super(id, successor);
        this.operations = operations;
    }

    public long[] getOperations() {
        return this.operations;
    }

    @Override
    void apply(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        DFABQTrackingTransitionOpsNode.applyOperations(locals, executor, this.operations);
    }

    @ExplodeLoop
    static void applyOperations(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, long[] ops) {
        CompilerAsserts.partialEvaluationConstant((Object)ops);
        for (long op : ops) {
            int qId = TransitionOp.getQuantifierID(op);
            CompilerAsserts.partialEvaluationConstant((long)op);
            CompilerAsserts.partialEvaluationConstant((int)qId);
            CounterTracker counterTracker = executor.getCounterTrackers()[qId];
            CompilerAsserts.partialEvaluationConstant((Object)counterTracker);
            counterTracker.apply(op, locals.getFixedData(), locals.getIntArrays());
        }
    }
}

