/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.compiler.BytecodeCodeUnit;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.bytecode.MakeFunctionNodeGen;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.Source;

public abstract class MakeFunctionNode
extends PNodeWithContext {
    private final RootCallTarget callTarget;
    private final BytecodeCodeUnit code;
    private final Signature signature;
    @CompilerDirectives.CompilationFinal
    private PCode cachedCode;
    private final Assumption codeStableAssumption = Truffle.getRuntime().createAssumption("code stable assumption");

    public abstract int execute(VirtualFrame var1, Object var2, int var3, int var4);

    public MakeFunctionNode(RootCallTarget callTarget, BytecodeCodeUnit code, Signature signature) {
        this.callTarget = callTarget;
        this.code = code;
        this.signature = signature;
    }

    @Specialization
    int makeFunction(VirtualFrame frame, Object globals, int initialStackTop, int flags, @Bind PythonLanguage language, @Cached WriteAttributeToPythonObjectNode writeAttrNode) {
        int stackTop = initialStackTop;
        PCode codeObj = this.cachedCode;
        if (codeObj == null) {
            if (PythonLanguage.get(this).isSingleContext()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedCode = codeObj = PFactory.createCode(language, this.callTarget, this.signature, this.code);
            } else {
                codeObj = PFactory.createCode(language, this.callTarget, this.signature, this.code);
            }
        }
        PCell[] closure = null;
        Object annotations = null;
        PKeyword[] kwdefaults = null;
        Object[] defaults = null;
        if ((flags & 8) != 0) {
            closure = (PCell[])frame.getObject(stackTop);
            frame.setObject(stackTop--, null);
        }
        if ((flags & 4) != 0) {
            annotations = frame.getObject(stackTop);
            frame.setObject(stackTop--, null);
        }
        if ((flags & 2) != 0) {
            kwdefaults = (PKeyword[])frame.getObject(stackTop);
            frame.setObject(stackTop--, null);
        }
        if ((flags & 1) != 0) {
            defaults = (Object[])frame.getObject(stackTop);
            frame.setObject(stackTop--, null);
        }
        PFunction function = PFactory.createFunction(language, this.code.name, this.code.qualname, codeObj, (PythonObject)globals, defaults, kwdefaults, closure, this.codeStableAssumption);
        if (annotations != null) {
            writeAttrNode.execute(function, SpecialAttributeNames.T___ANNOTATIONS__, annotations);
        }
        frame.setObject(++stackTop, (Object)function);
        return stackTop;
    }

    public static MakeFunctionNode create(PythonLanguage language, BytecodeCodeUnit code, Source source) {
        PBytecodeRootNode bytecodeRootNode = PBytecodeRootNode.create(language, code, source);
        RootCallTarget callTarget = code.isGeneratorOrCoroutine() ? new PBytecodeGeneratorFunctionRootNode(language, bytecodeRootNode.getFrameDescriptor(), bytecodeRootNode, code.name).getCallTarget() : bytecodeRootNode.getCallTarget();
        return MakeFunctionNodeGen.create(callTarget, code, bytecodeRootNode.getSignature());
    }

    public RootCallTarget getCallTarget() {
        return this.callTarget;
    }
}

