/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseAllNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseAllSettledNodeGen;
import com.oracle.truffle.js.nodes.promise.PerformPromiseCombinatorNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;

public abstract class PerformPromiseAllSettledNode
extends PerformPromiseAllNode {
    protected PerformPromiseAllSettledNode(JSContext context) {
        super(context);
    }

    public static PerformPromiseAllSettledNode create(JSContext context) {
        return PerformPromiseAllSettledNodeGen.create(context);
    }

    @Override
    @Specialization
    protected JSDynamicObject promiseAll(IteratorRecord iteratorRecord, JSDynamicObject constructor, PromiseCapabilityRecord resultCapability, Object promiseResolve, @Cached InlinedBranchProfile growProfile) {
        return super.promiseAll(iteratorRecord, constructor, resultCapability, promiseResolve, growProfile);
    }

    @Override
    protected JSFunctionObject createResolveElementFunction(int index, SimpleArrayList<Object> values, PromiseCapabilityRecord resultCapability, PerformPromiseCombinatorNode.BoxedInt remainingElementsCount) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.PromiseAllSettledResolveElement, c -> PerformPromiseAllSettledNode.createResolveElementFunctionImpl(c));
        JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
        this.setArgs.setValue((Object)function, new PerformPromiseAllNode.ResolveElementArgs(index, values, resultCapability, remainingElementsCount));
        return function;
    }

    @Override
    protected Object createRejectElementFunction(int index, SimpleArrayList<Object> values, PromiseCapabilityRecord resultCapability, PerformPromiseCombinatorNode.BoxedInt remainingElementsCount) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.PromiseAllSettledRejectElement, c -> PerformPromiseAllSettledNode.createRejectElementFunctionImpl(c));
        JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
        this.setArgs.setValue((Object)function, new PerformPromiseAllNode.ResolveElementArgs(index, values, resultCapability, remainingElementsCount));
        return function;
    }

    private static JSFunctionData createResolveElementFunctionImpl(JSContext context) {
        class PromiseAllSettledResolveElementRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode valueNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private PropertyGetNode getArgs = PropertyGetNode.createGetHidden(PerformPromiseAllNode.RESOLVE_ELEMENT_ARGS_KEY, this.val$context);
            @Node.Child
            private JSFunctionCallNode callResolve = JSFunctionCallNode.createCall();
            @Node.Child
            private CreateObjectNode objectCreateNode = CreateObjectNode.create(this.val$context);
            @Node.Child
            private CreateDataPropertyNode createStatusPropertyNode = CreateDataPropertyNode.create(this.val$context, Strings.STATUS);
            @Node.Child
            private CreateDataPropertyNode createValuePropertyNode = CreateDataPropertyNode.create(this.val$context, Strings.VALUE);
            final /* synthetic */ JSContext val$context;

            PromiseAllSettledResolveElementRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            public Object execute(VirtualFrame frame) {
                JSFunctionObject functionObject = JSFrameUtil.getFunctionObject((Frame)frame);
                PerformPromiseAllNode.ResolveElementArgs args = (PerformPromiseAllNode.ResolveElementArgs)this.getArgs.getValue((Object)functionObject);
                if (args.alreadyCalled) {
                    return Undefined.instance;
                }
                args.alreadyCalled = true;
                Object value = this.valueNode.execute(frame);
                JSRealm realm = this.getRealm();
                JSObject obj = this.objectCreateNode.execute(realm);
                this.createStatusPropertyNode.executeVoid((Object)obj, Strings.FULFILLED);
                this.createValuePropertyNode.executeVoid((Object)obj, value);
                args.values.set(args.index, (Object)obj);
                --args.remainingElements.value;
                if (args.remainingElements.value == 0) {
                    JSArrayObject valuesArray = JSArray.createConstantObjectArray(this.val$context, realm, args.values.toArray());
                    return this.callResolve.executeCall(JSArguments.createOneArg((Object)Undefined.instance, args.capability.getResolve(), valuesArray));
                }
                return Undefined.instance;
            }
        }
        return JSFunctionData.createCallOnly(context, (CallTarget)new PromiseAllSettledResolveElementRootNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    private static JSFunctionData createRejectElementFunctionImpl(JSContext context) {
        class PromiseAllSettledRejectElementRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode valueNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private PropertyGetNode getArgs = PropertyGetNode.createGetHidden(PerformPromiseAllNode.RESOLVE_ELEMENT_ARGS_KEY, this.val$context);
            @Node.Child
            private JSFunctionCallNode callResolve = JSFunctionCallNode.createCall();
            @Node.Child
            private CreateObjectNode objectCreateNode = CreateObjectNode.create(this.val$context);
            @Node.Child
            private CreateDataPropertyNode createStatusPropertyNode = CreateDataPropertyNode.create(this.val$context, Strings.STATUS);
            @Node.Child
            private CreateDataPropertyNode createReasonPropertyNode = CreateDataPropertyNode.create(this.val$context, Strings.REASON);
            final /* synthetic */ JSContext val$context;

            PromiseAllSettledRejectElementRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            public Object execute(VirtualFrame frame) {
                JSFunctionObject functionObject = JSFrameUtil.getFunctionObject((Frame)frame);
                PerformPromiseAllNode.ResolveElementArgs args = (PerformPromiseAllNode.ResolveElementArgs)this.getArgs.getValue((Object)functionObject);
                if (args.alreadyCalled) {
                    return Undefined.instance;
                }
                args.alreadyCalled = true;
                Object value = this.valueNode.execute(frame);
                JSRealm realm = this.getRealm();
                JSObject obj = this.objectCreateNode.execute(realm);
                this.createStatusPropertyNode.executeVoid((Object)obj, Strings.REJECTED);
                this.createReasonPropertyNode.executeVoid((Object)obj, value);
                args.values.set(args.index, (Object)obj);
                --args.remainingElements.value;
                if (args.remainingElements.value == 0) {
                    JSArrayObject valuesArray = JSArray.createConstantObjectArray(this.val$context, realm, args.values.toArray());
                    return this.callResolve.executeCall(JSArguments.createOneArg((Object)Undefined.instance, args.capability.getResolve(), valuesArray));
                }
                return Undefined.instance;
            }
        }
        return JSFunctionData.createCallOnly(context, (CallTarget)new PromiseAllSettledRejectElementRootNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
    }
}

