/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.FixedUnit;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserDimension
extends AbstractTeXObject
implements TeXDimension,
Expandable {
    private float value;
    private TeXUnit unit;
    public static final Pattern DIMENSION_PATTERN = Pattern.compile("\\s*(\\d*(?:\\.\\d+)?\\d)\\s*([a-z]{2})\\s*");

    public UserDimension() {
        this(0.0f, (TeXUnit)FixedUnit.PT);
    }

    public UserDimension(double d, TeXUnit teXUnit) {
        this((float)d, teXUnit);
    }

    public UserDimension(float f, TeXUnit teXUnit) {
        this.value = f;
        this.unit = teXUnit;
    }

    public UserDimension(Float f, TeXUnit teXUnit) {
        this(f.floatValue(), teXUnit);
    }

    public UserDimension(TeXNumber teXNumber, TeXUnit teXUnit) {
        this.value = teXNumber.getValue();
        this.unit = teXUnit;
    }

    public UserDimension(TeXParser teXParser, String string) throws TeXSyntaxException {
        Matcher matcher = DIMENSION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", string);
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        try {
            this.value = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", string);
        }
        this.unit = teXParser.getListener().createUnit(string3);
    }

    @Override
    public Object clone() {
        return new UserDimension(this.value, this.unit);
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.unit.toSp(teXParser, this.value);
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public TeXUnit getUnit() {
        return this.unit;
    }

    public void setValue(float f, TeXUnit teXUnit) {
        this.value = f;
        this.unit = teXUnit;
    }

    public void setValue(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (!(numerical instanceof TeXDimension)) {
            this.setValue(numerical.number(teXParser), FixedUnit.SP);
            throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", numerical.toString(teXParser));
        }
        this.setDimension(teXParser, (TeXDimension)numerical);
    }

    @Override
    public void setDimension(TeXParser teXParser, TeXDimension teXDimension) {
        this.setValue(teXDimension.getValue(), teXDimension.getUnit());
    }

    @Override
    public String toString(TeXParser teXParser) {
        return String.format("%f%s", Float.valueOf(this.value), this.unit.toString(teXParser));
    }

    @Override
    public String format() {
        return String.format("%f%s", Float.valueOf(this.value), this.unit.format());
    }

    public String toString() {
        return String.format("%s[value=%f,unit=%s]", this.getClass().getSimpleName(), Float.valueOf(this.value), this.unit.toString());
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString(teXParser));
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (!(numerical instanceof TeXDimension)) {
            throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", numerical.toString(teXParser));
        }
        TeXDimension teXDimension = (TeXDimension)numerical;
        TeXUnit teXUnit = teXDimension.getUnit();
        if (this.unit.equals(teXUnit)) {
            this.value += teXDimension.getValue();
            return;
        }
        if (!(this.unit instanceof FixedUnit)) {
            if (teXUnit instanceof FixedUnit) {
                this.value = teXUnit.fromUnit(teXParser, this.value, this.unit) + teXDimension.getValue();
                this.unit = teXDimension.getUnit();
                return;
            }
            this.value = this.unit.toPt(teXParser, this.value);
            this.unit = FixedUnit.PT;
        }
        this.value += this.unit.toUnit(teXParser, teXDimension.getValue(), teXUnit);
    }

    @Override
    public void divide(int n) {
        this.value /= (float)n;
    }

    @Override
    public void multiply(int n) {
        this.value *= (float)n;
    }

    @Override
    public void multiply(float f) {
        this.value *= f;
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.string(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.string(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.addAll(0, this.string(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXObjectList.addAll(0, this.string(teXParser));
    }
}

