/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.pbf;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public final class Blob {
    private final Integer rawSize;
    private final CompressionType compressionType;
    private final byte[] bytes;

    public Blob(@Nullable Integer rawSize, @Nonnull CompressionType compressionType, byte ... bytes) {
        this.rawSize = rawSize;
        this.compressionType = compressionType;
        this.bytes = bytes;
    }

    @Nullable
    public Integer rawSize() {
        return this.rawSize;
    }

    @Nonnull
    public CompressionType compressionType() {
        return this.compressionType;
    }

    @Nonnull
    public byte[] bytes() {
        return this.bytes;
    }

    @Nonnull
    public InputStream inputStream() throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
        switch (this.compressionType) {
            case raw: {
                return bais;
            }
            case bzip2: {
                return new BZip2CompressorInputStream(bais);
            }
            case lzma: 
            case zstd: 
            case lz4: {
                throw new IOException(String.valueOf((Object)this.compressionType) + " pbf is not currently supported");
            }
            case zlib: {
                return new InflaterInputStream(bais);
            }
        }
        throw new IOException("unknown compression type is not currently supported: " + this.compressionType.name());
    }

    public static enum CompressionType {
        raw,
        zlib,
        lzma,
        bzip2,
        lz4,
        zstd;

    }
}

