<?php
/**
 * Aliases for Special:CheckUser
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'CheckUser' => [ 'CheckUser' ],
	'CheckUserLog' => [ 'CheckUserLog' ],
	'GlobalContributions' => [ 'GlobalContributions', 'GlobalContribs' ],
	'Investigate' => [ 'Investigate' ],
	'InvestigateBlock' => [ 'InvestigateBlock' ],
	'IPContributions' => [ 'IPContributions' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'CheckUser' => [ 'تدقيق_مستخدم' ],
	'CheckUserLog' => [ 'سجل_تدقيق_المستخدم' ],
	'Investigate' => [ 'تحقيق' ],
	'InvestigateBlock' => [ 'منع_التحقيق' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'CheckUser' => [ 'تدقيق_يوزر' ],
	'CheckUserLog' => [ 'سجل_التشيك-يوزر' ],
	'Investigate' => [ 'التحقيق' ],
	'InvestigateBlock' => [ 'البلوك_بتاع_التحقيق' ],
];

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = [
	'CheckUser' => [ 'সদস্যৰ_অনুসন্ধান_কৰক' ],
	'CheckUserLog' => [ 'সদস্যৰ_অভিলেখ_চাওক' ],
];

/** Avaric (авар) */
$specialPageAliases['av'] = [
	'CheckUser' => [ 'Проверить_участника' ],
	'CheckUserLog' => [ 'Журнал_проверок_участников' ],
];

/** Azerbaijani (Azərbaycanca) */
$specialPageAliases['az'] = [
	'CheckUser' => [ 'Təftiş' ],
	'CheckUserLog' => [ 'TəftişçiJurnalı' ],
	'GlobalContributions' => [ 'QlobalTöhfələr' ],
	'Investigate' => [ 'Araşdır' ],
	'InvestigateBlock' => [ 'AraşdırmaBloku' ],
	'IPContributions' => [ 'IPTöhfələri' ],
];

/** Bashkir (башҡортса) */
$specialPageAliases['ba'] = [
	'CheckUser' => [ 'CheckUser' ],
	'CheckUserLog' => [ 'CheckUserLog' ],
];

/** Bengali (বাংলা) */
$specialPageAliases['bn'] = [
	'CheckUser' => [ 'ব্যবহারকারী_পরীক্ষণ' ],
	'CheckUserLog' => [ 'ব্যবহারকারী_পরীক্ষণের_লগ' ],
	'GlobalContributions' => [ 'বৈশ্বিক_অবদান' ],
	'Investigate' => [ 'তদন্ত' ],
	'InvestigateBlock' => [ 'তদন্ত_বাধাদান' ],
	'IPContributions' => [ 'আইপির_অবদান', 'আইপি_অবদান' ],
];

/** Bulgarian (български) */
$specialPageAliases['bg'] = [
	'CheckUser' => [ 'Проверка_на_потребител' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'CheckUser' => [ 'کارمرزوکی_تلاشی_کورتین' ],
	'CheckUserLog' => [ 'کارمرزوکی_تلاشی_ئی_سیاهه' ],
];

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = [
	'CheckUser' => [ 'Tukui_pamakai' ],
];

/** Breton (brezhoneg) */
$specialPageAliases['br'] = [
	'CheckUser' => [ 'GwiriañAozer' ],
];

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = [
	'CheckUser' => [ 'ProvjeraKorisnika' ],
];

/** Catalan (català) */
$specialPageAliases['ca'] = [
	'CheckUser' => [ 'Verificació_de_comptes_d\'usuari' ],
	'CheckUserLog' => [ 'Registres_de_les_verificacions_de_comptes_d\'usuari' ],
];

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = [
	'CheckUser' => [ '檢查用戶' ],
	'CheckUserLog' => [ '檢查用戶日誌' ],
];

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = [
	'CheckUser' => [ 'Декъашхочунга_хьажар' ],
	'CheckUserLog' => [ 'Декъашхойн_нисдарийн_тептар' ],
];

$specialPageAliases['cs'] = [
	'CheckUser' => [ 'Zkontrolovat uživatele' ],
	'CheckUserLog' => [ 'Protokolovací záznamy kontrol uživatele' ],
	'Investigate' => [ 'Prošetřit_uživatele' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'CheckUser' => [ 'Checkuser' ],
	'CheckUserLog' => [ 'Checkuser-Logbuch' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'CheckUser' => [ 'KontrolkarKarber' ],
	'CheckUserLog' => [ 'KontrolkarKarberCıkewtış' ],
];

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = [
	'CheckUser' => [ 'Kontrolny_wužywaŕ' ],
];

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = [
	'CheckUser' => [ 'ΈλεγχοςΧρήστη' ],
];

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = [
	'CheckUser' => [ 'Kontroli_uzanton' ],
	'CheckUserLog' => [ 'Protokoloj_de_kontrolado_de_uzantoj' ],
];

/** Spanish (español) */
$specialPageAliases['es'] = [
	'CheckUser' => [ 'ComprobarUsuario', 'Comprobar_usuario', 'VerificarUsuario', 'Verificar_usuario' ],
	'CheckUserLog' => [ 'Registro_de_comprobación_de_usuarios', 'Registro_de_verificación_de_usuarios' ],
	'Investigate' => [ 'Investigar', 'Investigación' ],
];

/** Basque (euskara) */
$specialPageAliases['eu'] = [
	'CheckUser' => [ 'Lankidea_egiaztatu' ],
	'CheckUserLog' => [ 'Lankidearen_erregistroa_egiaztatu' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'CheckUser' => [ 'بازرسی_کاربر' ],
	'CheckUserLog' => [ 'سیاهه_بازرس_کاربر' ],
	'Investigate' => [ 'بررسی' ],
	'InvestigateBlock' => [ 'بررسی_بستن' ],
];

/** Finnish (suomi) */
$specialPageAliases['fi'] = [
	'CheckUser' => [ 'Tarkasta_käyttäjä' ],
	'CheckUserLog' => [ 'Osoitepaljastusloki' ],
];

/** French (français) */
$specialPageAliases['fr'] = [
	'CheckUser' => [ 'Vérificateur_d\'utilisateur', 'Vérificateur_d\'utilisateurs', 'VérificateurUtilisateur', 'VérificateurUtilisateurs', 'Vérificateur_d’adresse' ],
];

/** Arpitan (arpetan) */
$specialPageAliases['frp'] = [
	'CheckUser' => [ 'Controlor_d\'usanciér', 'ControlorDUsanciér' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'CheckUser' => [ 'Verificador_de_usuarios' ],
	'CheckUserLog' => [ 'Rexistro_de_verificación_de_usuarios' ],
];

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = [
	'CheckUser' => [ 'Benutzerpriefig' ],
];

/** Gujarati (ગુજરાતી) */
$specialPageAliases['gu'] = [
	'CheckUser' => [ 'સભ્યચકાસણી' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'CheckUser' => [ 'בדיקת_משתמש' ],
	'CheckUserLog' => [ 'יומן_בדיקת_משתמשים' ],
	'GlobalContributions' => [ 'תרומות_גלובליות' ],
	'Investigate' => [ 'חקירה' ],
	'InvestigateBlock' => [ 'חסימה_מרובה' ],
	'IPContributions' => [ 'תרומות_IP' ],
];

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = [
	'CheckUser' => [ 'सदस्य_जाँच' ],
	'CheckUserLog' => [ 'सदस्य_जाँच_लॉग' ],
];

/** Croatian (hrvatski) */
$specialPageAliases['hr'] = [
	'CheckUser' => [ 'Provjeri_suradnika' ],
];

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = [
	'CheckUser' => [ 'Kontrolny_wužiwar' ],
];

/** Xiang Chinese (湘语) */
$specialPageAliases['hsn'] = [
	'CheckUser' => [ '检查用户' ],
];

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = [
	'CheckUser' => [ 'TchekeItilizatè' ],
];

/** Hungarian (magyar) */
$specialPageAliases['hu'] = [
	'CheckUser' => [ 'IP-ellenőr' ],
];

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = [
	'CheckUser' => [ 'Verificar_usator' ],
	'CheckUserLog' => [ 'Verificar_registro_de_usatores' ],
];

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = [
	'CheckUser' => [ 'Periksa_pengguna', 'PeriksaPengguna', 'Pemeriksaan' ],
	'CheckUserLog' => [ 'Catatan_pemeriksaan' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'CheckUser' => [ 'CU' ],
	'CheckUserLog' => [ 'RegistroCheckUser' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'CheckUser' => [ 'チェックユーザー', 'チェックユーザ', '利用者調査' ],
	'CheckUserLog' => [ 'チェックユーザー記録', '利用者調査記録' ],
];

/** Georgian (ქართული) */
$specialPageAliases['ka'] = [
	'CheckUser' => [ 'ჩეკიუზერი' ],
];

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = [
	'CheckUser' => [ 'ត្រួតពិនិត្យអ្នកប្រើប្រាស់' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'CheckUser' => [ '사용자검사', '사용자확인' ],
	'CheckUserLog' => [ '사용자검사기록', '사용자확인기록' ],
	'GlobalContributions' => [ '전역기여' ],
	'Investigate' => [ '조사' ],
	'InvestigateBlock' => [ '조사차단' ],
	'IPContributions' => [ 'IP기여' ],
];

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = [
	'CheckUser' => [ 'Metmaacher_Pröve', 'Metmaacher_Pröfe' ],
];

/** Cornish (kernowek) */
$specialPageAliases['kw'] = [
	'CheckUser' => [ 'CheckyaDevnydhyer' ],
	'CheckUserLog' => [ 'CheckyaKovnotenAnDevnydhyer' ],
];

/** Ladino (Ladino) */
$specialPageAliases['lad'] = [
	'CheckUser' => [ 'KontrolarUsador' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'CheckUser' => [ 'Benotzerkontroll' ],
	'CheckUserLog' => [ 'Logbuch_vun_der_Benotzerkontroll' ],
];

/** Northern Luri (لۊری شومالی) */
$specialPageAliases['lrc'] = [
	'CheckUser' => [ 'ڤارئسی_کاریار' ],
	'CheckUserLog' => [ 'پئھرئستنوٙمە_ڤارئسی_کاریار' ],
];

/** Malagasy (Malagasy) */
$specialPageAliases['mg'] = [
	'CheckUser' => [ 'Mpanamarina_mpikambana', 'MpanamarinaMpikambana' ],
	'CheckUserLog' => [ 'LaogimpanamarinaMpikambana' ],
];

/** Minangkabau (Baso Minangkabau) */
$specialPageAliases['min'] = [
	'CheckUser' => [ 'ParesoPangguno' ],
	'CheckUserLog' => [ 'LogPamaresoan' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'CheckUser' => [ 'ПроверкаНаКорисник' ],
	'CheckUserLog' => [ 'ПроверкаНаКорисникДневник' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'CheckUser' => [ 'ചെക്ക്‌‌യൂസർ' ],
	'CheckUserLog' => [ 'ചെക്ക്‌യൂസർരേഖ' ],
];

/** Marathi (मराठी) */
$specialPageAliases['mr'] = [
	'CheckUser' => [ 'सदस्यतपासनिस' ],
];

/** Malay (Bahasa Melayu) */
$specialPageAliases['ms'] = [
	'CheckUser' => [ 'Perisik' ],
	'CheckUserLog' => [ 'Log_perisik' ],
];

/** Erzya (эрзянь) */
$specialPageAliases['myv'] = [
	'CheckUser' => [ 'ВанкшномсКиеТеицясь' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'CheckUser' => [ 'IP-sjekk' ],
	'CheckUserLog' => [ 'IP-sjekkingslogg' ],
	'GlobalContributions' => [ 'Bidrag_globalt', 'Globale_bidrag' ],
	'Investigate' => [ 'Undersøk' ],
	'InvestigateBlock' => [ 'Undersøkelsesblokkering' ],
	'IPContributions' => [ 'IP-bidrag' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = [
	'CheckUser' => [ 'Gebruker_opvragen' ],
	'CheckUserLog' => [ 'Logboek_gebruker_naokieken' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'CheckUser' => [ 'GebruikerControleren' ],
	'CheckUserLog' => [ 'LogboekGebruikerControleren' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = [
	'CheckUser' => [ 'IP-sjekk' ],
	'CheckUserLog' => [ 'IP-sjekkingslogg' ],
	'GlobalContributions' => [ 'Bidrag_globalt', 'Globale_bidrag' ],
	'Investigate' => [ 'Undersøk' ],
	'InvestigateBlock' => [ 'Undersøkingsblokkering' ],
	'IPContributions' => [ 'IP-bidrag' ],
];

/** Occitan (occitan) */
$specialPageAliases['oc'] = [
	'CheckUser' => [ 'Verificator_d’adreça', 'VerificatorAdreça', 'VerificatorAdreca' ],
];

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = [
	'CheckUser' => [ 'ਚੈੱਕ_ਵਰਤੋਂਕਾਰ' ],
	'CheckUserLog' => [ 'ਚੈੱਕ_ਵਰਤੋਂਕਾਰ_ਚਿੱਠਾ' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'CheckUser' => [ 'Sprawdź_IP_użytkownika', 'CheckUser', 'CU' ],
	'CheckUserLog' => [ 'Rejestr_sprawdzeń' ],
	'GlobalContributions' => [ 'Wkład_globalny' ],
	'Investigate' => [ 'Zbadaj_konta' ],
	'InvestigateBlock' => [ 'Zablokuj_po_zbadaniu' ],
	'IPContributions' => [ 'Wkład_IP' ],
];

/** Portuguese (português) */
$specialPageAliases['pt'] = [
	'CheckUser' => [ 'Verificar_usuário' ],
	'CheckUserLog' => [ 'Registo_de_verificação_de_usuário', 'Registro_de_verificação_de_usuário' ],
];

/** Brazilian Portuguese (português do Brasil) */
$specialPageAliases['pt-br'] = [
	'CheckUser' => [ 'Verificar_usuário' ],
	'CheckUserLog' => [ 'Registro_de_verificação_de_usuário', 'Registo_de_verificação_de_usuário' ],
];

/** Quechua (Runa Simi) */
$specialPageAliases['qu'] = [
	'CheckUser' => [ 'RuraqtaLlanchiy' ],
];

/** Romanian (română) */
$specialPageAliases['ro'] = [
	'CheckUser' => [ 'Verifică_utilizator' ],
];

/** Russian (русский) */
$specialPageAliases['ru'] = [
	'CheckUser' => [ 'Проверить_участника' ],
	'CheckUserLog' => [ 'Журнал_проверок_участников' ],
];

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = [
	'CheckUser' => [ 'योजकपरिक्षक' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'CheckUser' => [ 'CU' ],
	'CheckUserLog' => [ 'RegistroCU' ],
];

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = [
	'CheckUser' => [ 'SkontrolovaťPoužívateľa' ],
];

/** Albanian (shqip) */
$specialPageAliases['sq'] = [
	'CheckUser' => [ 'KontrolloPërdorues' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)) */
$specialPageAliases['sr-ec'] = [
	'CheckUser' => [ 'Провери_корисника', 'ПровериКорисника' ],
	'CheckUserLog' => [ 'Дневник_чекјузера', 'ДневникЧекјузера' ],
];

/** Serbian (Latin script) (srpski (latinica)) */
$specialPageAliases['sr-el'] = [
	'CheckUser' => [ 'Proveri_korisnika', 'ProveriKorisnika' ],
	'CheckUserLog' => [ 'Dnevnik_čekjuzera', 'DnevnikČekjuzera' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'CheckUser' => [ 'Kolla_användare' ],
	'CheckUserLog' => [ 'Kolla_användare_logg' ],
];

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = [
	'CheckUser' => [ 'MtumiajiMwangalizi' ],
];

/** Thai (ไทย) */
$specialPageAliases['th'] = [
	'CheckUser' => [ 'ตรวจสอบผู้ใช้' ],
	'CheckUserLog' => [ 'ปูมตรวจสอบผู้ใช้' ],
];

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = [
	'CheckUser' => [ 'Suriin_ang_tagagamit' ],
];

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = [
	'CheckUser' => [ 'Denetçi', 'KullanıcıDenetle' ],
	'CheckUserLog' => [ 'DenetçiGünlüğü' ],
];

/** Ukrainian (українська) */
$specialPageAliases['uk'] = [
	'CheckUser' => [ 'Перевірити_користувача', 'Проверить_участника' ],
	'CheckUserLog' => [ 'Журнал_перевірок_користувачів', 'Журнал_проверок_участников' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'CheckUser' => [ 'صارف_پڑتال' ],
	'CheckUserLog' => [ 'نوشتہ_صارف_پڑتال' ],
];

/** Venetian (vèneto) */
$specialPageAliases['vec'] = [
	'CheckUser' => [ 'ControlaUtente' ],
];

/** Veps (vepsän kel’) */
$specialPageAliases['vep'] = [
	'CheckUser' => [ 'KodvdaKävutajad' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'CheckUser' => [ 'Kiểm_tra_người_dùng' ],
	'CheckUserLog' => [ 'Nhật_trình_kiểm_tra_người_dùng' ],
];

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = [
	'CheckUser' => [ '用户查核' ],
	'CheckUserLog' => [ '用户查核日志' ],
];

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = [
	'CheckUser' => [ '使用者查核' ],
	'CheckUserLog' => [ '使用者查核日誌' ],
];

/** Chinese (Hong Kong) (中文（香港）‎) */
$specialPageAliases['zh-hk'] = [
	'CheckUser' => [ '用戶查核' ],
	'CheckUserLog' => [ '用戶查核日誌' ],
];
