/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.util.Optional;
import javax.annotation.Nullable;
import org.protege.editor.owl.model.selection.OWLEntitySelectionModel;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.model.OWLClass;

public abstract class SelectedOWLClassAction
extends ProtegeOWLAction {
    private OWLSelectionModelListener listener;

    public final void initialise() throws Exception {
        this.listener = () -> this.updateState();
        this.getOWLWorkspace().getOWLSelectionModel().addListener(this.listener);
        this.updateState();
    }

    protected void updateState() {
        OWLSelectionModel selectionModel = this.getOWLWorkspace().getOWLSelectionModel();
        Optional<OWLClass> selectedEntity = new OWLEntitySelectionModel(selectionModel).getSelectedClass();
        this.setEnabled(selectedEntity.isPresent());
    }

    @Nullable
    protected OWLClass getOWLClass() {
        return this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedClass();
    }

    protected abstract void initialiseAction() throws Exception;

    public void dispose() {
        if (this.listener != null) {
            this.getOWLWorkspace().getOWLSelectionModel().removeListener(this.listener);
        }
    }
}

