/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.nfi.ConvertTypeNode;

final class NFIType {
    @NeverDefault
    final TypeCachedState cachedState;
    final Object backendType;
    final Object runtimeData;

    NFIType(TypeCachedState cachedState, Object backendType) {
        this(cachedState, backendType, null);
    }

    NFIType(TypeCachedState cachedState, Object backendType, Object runtimeData) {
        assert (cachedState != null);
        this.cachedState = cachedState;
        this.backendType = backendType;
        this.runtimeData = runtimeData;
    }

    static class TypeCachedState {
        final int managedArgCount;
        final NodeFactory<? extends ConvertTypeNode> toNativeFactory;
        final NodeFactory<? extends ConvertTypeNode> fromNativeFactory;
        final Object defaultValue;

        TypeCachedState(int managedArgCount, NodeFactory<? extends ConvertTypeNode> toNative, NodeFactory<? extends ConvertTypeNode> fromNative, Object defaultValue) {
            this.managedArgCount = managedArgCount;
            this.toNativeFactory = toNative;
            this.fromNativeFactory = fromNative;
            this.defaultValue = defaultValue;
        }

        @NeverDefault
        ConvertTypeNode createToNative() {
            return (ConvertTypeNode)((Object)this.toNativeFactory.createNode(new Object[0]));
        }

        @NeverDefault
        ConvertTypeNode createFromNative() {
            return (ConvertTypeNode)((Object)this.fromNativeFactory.createNode(new Object[0]));
        }
    }
}

