/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.sql.Connection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.OptionsBuilder;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.TemplatingUtility;
import us.fatehi.utility.Utility;

public final class InformationSchemaViewsBuilder
implements OptionsBuilder<InformationSchemaViewsBuilder, InformationSchemaViews> {
    private final Map<InformationSchemaKey, String> informationSchemaQueries = new EnumMap<InformationSchemaKey, String>(InformationSchemaKey.class);

    public static InformationSchemaViewsBuilder builder() {
        return new InformationSchemaViewsBuilder();
    }

    public static InformationSchemaViewsBuilder builder(InformationSchemaViews informationSchemaViews) {
        return new InformationSchemaViewsBuilder().fromOptions(informationSchemaViews);
    }

    public static InformationSchemaViews newInformationSchemaViews() {
        return new InformationSchemaViews();
    }

    private InformationSchemaViewsBuilder() {
    }

    public InformationSchemaViewsBuilder fromOptions(InformationSchemaViews informationSchemaViews) {
        if (informationSchemaViews == null) {
            return this;
        }
        this.informationSchemaQueries.putAll(informationSchemaViews.getAllInformationSchemaViews());
        return this;
    }

    public InformationSchemaViewsBuilder fromResourceFolder(String classpath) {
        if (Utility.isBlank((CharSequence)classpath)) {
            return this;
        }
        for (InformationSchemaKey key : InformationSchemaKey.values()) {
            String resource = "%s/%s.sql".formatted(new Object[]{classpath, key});
            String sql = IOUtility.readResourceFully((String)resource);
            if (Utility.isBlank((CharSequence)sql)) continue;
            this.informationSchemaQueries.put(key, sql);
        }
        return this;
    }

    public void substituteAll(String templateKey, String templateValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(templateKey, templateValue);
        for (Map.Entry<InformationSchemaKey, String> query : this.informationSchemaQueries.entrySet()) {
            String sql = query.getValue();
            sql = TemplatingUtility.expandTemplate((String)sql, map);
            query.setValue(sql);
        }
    }

    @Override
    public InformationSchemaViews toOptions() {
        return new InformationSchemaViews(this.informationSchemaQueries);
    }

    public InformationSchemaViewsBuilder withFunction(BiConsumer<InformationSchemaViewsBuilder, Connection> informationSchemaViewsBuilderForConnection, Connection connection) {
        if (informationSchemaViewsBuilderForConnection != null) {
            informationSchemaViewsBuilderForConnection.accept(this, connection);
        }
        return this;
    }

    public InformationSchemaViewsBuilder withSql(InformationSchemaKey key, String sql) {
        Objects.requireNonNull(key, "No key provided");
        if (Utility.isBlank((CharSequence)sql)) {
            this.informationSchemaQueries.remove((Object)key);
        } else {
            this.informationSchemaQueries.put(key, sql);
        }
        return this;
    }
}

