/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSourceConnection;

public class PooledConnectionUtility {
    public static Connection newPooledConnection(Connection connection, DatabaseConnectionSource databaseConnectionSource) {
        return (Connection)Proxy.newProxyInstance(PooledConnectionUtility.class.getClassLoader(), new Class[]{Connection.class, DatabaseConnectionSourceConnection.class}, (InvocationHandler)new PooledConnectionInvocationHandler(connection, databaseConnectionSource));
    }

    private PooledConnectionUtility() {
    }

    private static class PooledConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection connection;
        private final DatabaseConnectionSource databaseConnectionSource;
        private boolean isClosed;

        PooledConnectionInvocationHandler(Connection connection, DatabaseConnectionSource databaseConnectionSource) {
            Objects.requireNonNull(connection, "No database connnection provided");
            if (connection instanceof DatabaseConnectionSourceConnection) {
                try {
                    this.connection = connection.unwrap(Connection.class);
                }
                catch (SQLException e) {
                    throw new UnsupportedOperationException("Could not unwrap proxy connection");
                }
            } else {
                this.connection = connection;
            }
            this.databaseConnectionSource = Objects.requireNonNull(databaseConnectionSource, "No database connection source provided");
            this.isClosed = false;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            String methodName = method.getName();
            if (!Arrays.asList("isClosed", "unwrap").contains(methodName) && this.isClosed) {
                throw new SQLException("Cannot call <%s> since connection is closed".formatted(method));
            }
            switch (methodName) {
                case "close": {
                    this.databaseConnectionSource.releaseConnection(this.connection);
                    this.isClosed = true;
                    return null;
                }
                case "isClosed": {
                    return this.isClosed;
                }
                case "isWrapperFor": {
                    Class clazz = (Class)args[0];
                    return clazz.isAssignableFrom(this.connection.getClass());
                }
                case "unwrap": {
                    return this.connection;
                }
                case "toString": {
                    return "Pooled connection <%s@%d> for <%s>".formatted(proxy.getClass().getName(), proxy.hashCode(), this.connection);
                }
            }
            try {
                return method.invoke((Object)this.connection, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    Exception exception = (Exception)cause;
                    throw exception;
                }
                throw new SQLException("Could not delegate method <%s>".formatted(method), e);
            }
        }
    }
}

