/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import vtk.vtkObjectBase;
import vtk.vtkReferenceInformation;

public class vtkJavaGarbageCollector {
    private ScheduledExecutorService executor;
    private Runnable deleteRunnable;
    private Runnable deferredEdtRunnable;
    private long periodTime = 1L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private boolean autoCollectionRunning = false;
    private boolean debug = false;

    public vtkJavaGarbageCollector() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.deleteRunnable = new Runnable(){

            @Override
            public void run() {
                vtkReferenceInformation vtkReferenceInformation2 = vtkObjectBase.JAVA_OBJECT_MANAGER.gc(vtkJavaGarbageCollector.this.debug);
                if (vtkJavaGarbageCollector.this.debug) {
                    System.out.println(vtkReferenceInformation2);
                    System.out.println(vtkReferenceInformation2.listKeptReferenceToString());
                    System.out.println(vtkReferenceInformation2.listRemovedReferenceToString());
                }
            }
        };
        this.deferredEdtRunnable = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(vtkJavaGarbageCollector.this.deleteRunnable);
            }
        };
    }

    public void SetScheduleTime(long l, TimeUnit timeUnit) {
        this.periodTime = l;
        this.timeUnit = timeUnit;
        this.SetAutoGarbageCollection(this.autoCollectionRunning);
    }

    public void SetDebug(boolean bl) {
        this.debug = bl;
    }

    public void SetAutoGarbageCollection(boolean bl) {
        this.autoCollectionRunning = bl;
        this.executor.shutdown();
        if (bl) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.executor.scheduleAtFixedRate(this.deferredEdtRunnable, this.periodTime, this.periodTime, this.timeUnit);
        }
    }

    public void Start() {
        this.SetAutoGarbageCollection(true);
    }

    public void Stop() {
        this.SetAutoGarbageCollection(false);
    }

    public Runnable GetDeleteRunnable() {
        return this.deleteRunnable;
    }
}

